<?php

namespace App\Services\Student;

use App\Constants\Status;
use App\Models\Academic\AcademicYear;
use App\Models\Academic\Group;
use App\Models\Academic\Shift;
use App\Models\Academic\StudentClass;
use App\Models\Result\Exam;
use App\Models\Result\ExamRecord;
use App\Models\Student\StudentInfo;
use App\Models\Student\StudentPromotion;
use App\Models\Result\MarkHeadAssign;
use App\Models\Result\Grade;
use Illuminate\Http\Request;

class StudentPromotionService
{

    // public function getStudentsByClass(Request $request)
    // {
    //     // Get current active exam
    //     $currentActiveExam = Exam::where('is_published', true)->first();
    
    //     // Get assigned marks head for the class
    //     $assignedMarksHead = MarkHeadAssign::where('student_class_id', $request->from_class)
    //         ->pluck('head_marks', 'subject_id')
    //         ->map(function ($marks) {
    //             $marksArray = json_decode($marks, true);
    //             return array_sum($marksArray);
    //         });
    
    //     // Get grades for comparison
    //     $grades = Grade::orderBy('mark_from')->get();
    
    //     // Get exam records grouped by student
    //     $examRecords = ExamRecord::where('class_id', $request->from_class)
    //         ->where('exam_id', $currentActiveExam->id)
    //         ->where('year', $request->from_academic_year)
    //         ->when($request->from_shift, function ($query) use ($request) {
    //             $query->where('shift_id', $request->from_shift);
    //         })
    //         ->when($request->from_section, function ($query) use ($request) {
    //             $query->where('section_id', $request->from_section);
    //         })
    //         ->get()
    //         ->groupBy('student_id');
    
    //     $studentIdsWithRecords = $examRecords->keys();
    
    //     // Get students
    //     $students = StudentInfo::where('student_class_id', $request->from_class)
    //         ->whereIn('id', $studentIdsWithRecords)
    //         ->get();
    
    //     // Calculate student results
    //     $studentResults = [];
    //     foreach ($examRecords as $studentId => $records) {
    //         $totalMarks = $records->sum('total_marks');
    //         $totalAssignedMarks = 0;
    //         $failedSubjects = 0;
    
    //         foreach ($records as $record) {
    //             $totalAssignedMarks += $assignedMarksHead[$record->subject_id] ?? 0;
    
    //             $subjectPercentage = ($record->total_marks / ($assignedMarksHead[$record->subject_id] ?? 1)) * 100;
    
    //             $grade = $grades->first(function ($grade) use ($subjectPercentage) {
    //                 return $subjectPercentage >= $grade->mark_from && $subjectPercentage <= $grade->mark_to;
    //             });
    
    //             if ($grade && $grade->name === 'F') {
    //                 $failedSubjects++;
    //             }
    //         }
    
    //         $percentage = $totalAssignedMarks > 0 ? ($totalMarks / $totalAssignedMarks) * 100 : 0;
    
    //         $studentResults[$studentId] = [
    //             'total_marks' => $totalMarks,
    //             'total_assigned_marks' => $totalAssignedMarks,
    //             'percentage' => $percentage,
    //             'failed_subjects' => $failedSubjects,
    //         ];
    //     }
    
    //     // Add result data to students
    //     foreach ($students as $student) {
    //         $result = $studentResults[$student->id] ?? null;
    //         $student->total_marks = $result['total_marks'] ?? 0;
    //         $student->total_assigned_marks = $result['total_assigned_marks'] ?? 0;
    //         $student->avg_percentage = $result['percentage'] ?? 0;
    //         $student->failed_subjects = $result['failed_subjects'] ?? 0;
    //         $student->current_position = $student->class_roll ?? 'N/A';
    
    //         $student->result_status = $result ? 
    //             ($result['failed_subjects'] > 0 ? "Fail ({$result['failed_subjects']} subjects)" : 'Pass') : 
    //             'No Result';
    //     }
    
    //     // Sort students by total marks, percentage, and class roll
    //     $students = $students->sortByDesc(function ($student) {
    //         return [
    //             $student->failed_subjects === 0 ? 1 : 0, // Priority pass students
    //             $student->total_marks,                  // Total marks descending
    //             $student->avg_percentage,               // Break tie with percentage
    //             -($student->class_roll ?? PHP_INT_MAX), // Prioritize lower roll number (asc)
    //         ];
    //     })->values(); // Re-index after sorting
    
    //     // Assign merit positions
    //     $position = 1;
    //     foreach ($students as $student) {
    //         $student->merit_position = $position++;
    //     }
    
    //     return $students;
    // }

    // public function getStudentsByClass(Request $request)
    // {
    //     // Current active exam
    //     $currentActiveExam = Exam::where('is_published', true)->first();
    
    //     // Get assigned marks head for the class
    //     $assignedMarksHead = MarkHeadAssign::where('student_class_id', $request->from_class)
    //         ->pluck('head_marks', 'subject_id')
    //         ->map(function($marks) {
    //             // Convert JSON string to array and sum all mark values
    //             $marksArray = json_decode($marks, true);
    //             return array_sum($marksArray);
    //         });
    
    //     // Get grades for comparison
    //     $grades = Grade::orderBy('mark_from')->get();
    
    //     // Get exam records with total marks
    //     $examRecords = ExamRecord::where('class_id', $request->from_class)
    //         ->where('exam_id', $currentActiveExam->id)
    //         ->where('year', $request->from_academic_year)
    //         ->when($request->from_shift, function ($query) use ($request) {
    //             $query->where('shift_id', $request->from_shift);
    //         })
    //         ->when($request->from_section, function ($query) use ($request) {
    //             $query->where('section_id', $request->from_section);
    //         })
    //         ->get()
    //         ->groupBy('student_id');
    
    //     // Get student IDs from exam records
    //     $studentIdsWithRecords = $examRecords->keys();
    
    //     // Get students with their current positions
    //     $students = StudentInfo::where('student_class_id', $request->from_class)
    //         ->whereIn('id', $studentIdsWithRecords)
    //         ->get();
    
    //     // Calculate student results
    //     $studentResults = [];
    //     foreach ($examRecords as $studentId => $records) {
    //         $totalMarks = $records->sum('total_marks');
    //         $totalAssignedMarks = 0;
    //         $failedSubjects = 0;
    
    //         foreach ($records as $record) {
    //             $totalAssignedMarks += $assignedMarksHead[$record->subject_id] ?? 0;
    
    //             // Calculate percentage for this subject
    //             $subjectPercentage = ($record->total_marks / ($assignedMarksHead[$record->subject_id] ?? 1)) * 100;
    
    //             // Find grade for this mark
    //             $grade = $grades->first(function($grade) use ($subjectPercentage) {
    //                 return $subjectPercentage >= $grade->mark_from && $subjectPercentage <= $grade->mark_to;
    //             });
    
    //             // Check if subject is failed (grade F)
    //             if ($grade && $grade->name === 'F') {
    //                 $failedSubjects++;
    //             }
    //         }
    
    //         $percentage = $totalAssignedMarks > 0 ? ($totalMarks / $totalAssignedMarks) * 100 : 0;
    
    //         $studentResults[$studentId] = [
    //             'total_marks' => $totalMarks,
    //             'total_assigned_marks' => $totalAssignedMarks,
    //             'percentage' => $percentage,
    //             'failed_subjects' => $failedSubjects
    //         ];
    //     }
    
    //     // Add result data to each student
    //     foreach ($students as $student) {
    //         $result = $studentResults[$student->id] ?? null;
    //         $student->total_marks = $result['total_marks'] ?? 0;
    //         $student->total_assigned_marks = $result['total_assigned_marks'] ?? 0;
    //         $student->avg_percentage = $result['percentage'] ?? 0;
    //         $student->failed_subjects = $result['failed_subjects'] ?? 0;
    //         $student->current_position = $student->class_roll ?? 'N/A';
    
    //         // Calculate result status
    //         if ($result) {
    //             $student->result_status = $result['failed_subjects'] > 0 ? 
    //                 "Fail ({$result['failed_subjects']} subjects)" : 'Pass';
    //         } else {
    //             $student->result_status = 'No Result';
    //         }
    //     }
    
    //     // Sort students by total marks and then by class roll for new positions
    //     $students = $students->sortByDesc(function($student) {
    //         return [$student->total_marks, -$student->class_roll]; // Sort by total marks and then by class roll (descending)
    //     });
    
    //     // Assign merit positions
    //     $position = 1;
    //     foreach ($students as $student) {
    //         $student->merit_position = $position++;
    //     }
    
    //     return $students;
    // }

    public function getStudentsByClass(Request $request)
    {
        // Current active exam
        $currentActiveExam = Exam::where('is_published', true)->first();
    
        // Get assigned marks head for the class
        $assignedMarksHead = MarkHeadAssign::where('student_class_id', $request->from_class)
            ->where('exam_id', $request->exam_id)
            ->pluck('head_marks', 'subject_id')
            ->map(function($marks) {
                // Convert JSON string to array and sum all mark values
                $marksArray = json_decode($marks, true);
                return array_sum($marksArray);
            });

        $assignedMarksHead2 = MarkHeadAssign::where('student_class_id', $request->from_class)
            ->where('exam_id', $request->exam_id)
            ->pluck('head_marks', 'subject_id');
        if ($assignedMarksHead2->isEmpty()) {
            return back()->with('error', 'Marks head not assigned for this class & exam.');
        }

        // dd($request->all(), $assignedMarksHead2);
        // Get grades for comparison
        $grades = Grade::orderBy('mark_from')->get();
    
        // Get exam records with total marks
        $examRecords = ExamRecord::where('class_id', $request->from_class)
            ->where('exam_id', $currentActiveExam->id)
            ->where('year', $request->from_academic_year)
            ->when($request->from_shift, function ($query) use ($request) {
                $query->where('shift_id', $request->from_shift);
            })
            ->when($request->from_section, function ($query) use ($request) {
                $query->where('section_id', $request->from_section);
            })
            ->get()
            ->groupBy('student_id');

    
        // Get student IDs from exam records
        $studentIdsWithRecords = $examRecords->keys();


        // dd($studentIdsWithRecords);
    
        // Get students with their current positions
        $students = StudentInfo::where('student_class_id', $request->from_class)
            ->whereIn('id', $studentIdsWithRecords)
            ->get();
        // dd($students);
        // Calculate student results
        $studentResults = [];
        foreach ($examRecords as $studentId => $records) {
            $totalMarks = $records->sum('total_marks');
            $totalAssignedMarks = 0;
            $failedSubjects = 0;
            $head_wise_fail_count = 0;
            foreach ($records as $record) {
                $totalAssignedMarks += $assignedMarksHead[$record->subject_id] ?? 0;
    
                // Calculate percentage for this subject
                $subjectPercentage = ($record->total_marks / ($assignedMarksHead[$record->subject_id] ?? 1)) * 100;


    
                // Find grade for this mark
                $grade = $grades->first(function($grade) use ($subjectPercentage) {
                    return $subjectPercentage >= $grade->mark_from && $subjectPercentage <= $grade->mark_to;
                });
                // Check if subject is failed (grade F)
                // if ($grade && $grade->name === 'F') {
                //     $failedSubjects++;
                // }



                // ==============================
                // HEAD-WISE PASS FAIL CHECK
                // ==============================
                $head_wise_pass_fail = [];
                // $head_marks_data = $assignedMarksHead[$record->subject->id];
                $head_marks_data = $assignedMarksHead2[$record->subject->id];
                $head_marks_array2 = json_decode($head_marks_data, true); // total marks per head
                $head_wise_marks_record2 = json_decode($record->head_wise_marks, true); // student marks
                // dd($head_marks_array2, $record->subject->id, $head_wise_marks_record2, $record->subject->id);
                foreach ($head_marks_array2 as $head_id => $total_marks) {
                    $pass_marks = $total_marks * 0.33;  // 33%
                    $marks_obtained = $head_wise_marks_record2[$head_id] ?? 0;

                    $head_wise_pass_fail[$head_id] = ($marks_obtained >= $pass_marks)
                        ? 'Pass'
                        : 'Fail';
                }

                // subject fail if ANY head failed
                if (in_array('Fail', $head_wise_pass_fail)) {
                    $head_wise_fail_count++;
                    $failedSubjects++;
                }

            }
    
            $percentage = $totalAssignedMarks > 0 ? ($totalMarks / $totalAssignedMarks) * 100 : 0;
    
            $studentResults[$studentId] = [
                'total_marks' => $totalMarks,
                'total_assigned_marks' => $totalAssignedMarks,
                'percentage' => $percentage,
                'failed_subjects' => $failedSubjects
            ];
        }


                // dd($studentId , $head_wise_fail_count, $record->head_wise_marks, $assignedMarksHead[$record->subject_id]);
    
        // Add result data to each student
        foreach ($students as $student) {
            $result = $studentResults[$student->id] ?? null;
            $student->total_marks = $result['total_marks'] ?? 0;
            $student->total_assigned_marks = $result['total_assigned_marks'] ?? 0;
            $student->avg_percentage = $result['percentage'] ?? 0;
            $student->failed_subjects = $result['failed_subjects'] ?? 0;
            $student->current_position = $student->class_roll ?? 'N/A';
    
            // Calculate result status
            if ($result) {
                $student->result_status = $result['failed_subjects'] > 0 ? 
                    "Fail ({$result['failed_subjects']} subjects)" : 'Pass';
            } else {
                $student->result_status = 'No Result';
            }
        }
    
        // Sort students by total marks and then by class roll for new positions
        $students = $students->sortByDesc(function($student) {
            return [$student->total_marks, -$student->class_roll]; // Sort by total marks and then by class roll (descending)
        });
    
        // Assign merit positions
        $position = 1;
        foreach ($students as $student) {
            $student->merit_position = $position++;
        }
    
        return $students;
    }

    public function promoteStudents($request)
    {

        foreach ($request->student_ids as $studentId) {

            $existingPromotion = StudentPromotion::where('student_id', $studentId)
                ->where('from_academic_year_id', $request->from_academic_year)
                ->where('from_class_id', $request->from_class)
                ->when($request->from_section, function ($query) use ($request) {
                    $query->where('from_section_id', $request->from_section);
                })
                ->first();
            $studentInfo = StudentInfo::where('id', $studentId)->first();

            $group = array_key_exists($studentId, $request->group) ? $request->group[$studentId] : null;
            $previousRollNumber = array_key_exists($studentId, $request->previous_roll_number) ? $request->previous_roll_number[$studentId] : null;
            $currentRollNumber = array_key_exists($studentId, $request->current_roll_number) ? $request->current_roll_number[$studentId] : null;
            $fromSection = $request->from_section ?? null;
            $toSection = array_key_exists($studentId, $request->to_section) ? $request->to_section[$studentId] : null;

            $promotionData = [
                'student_id' => $studentId,

                'from_branch_id' => auth()->user()->branch_id,
                'from_shift_id' => $studentInfo->shift_id,
                'from_class_id' => $request->from_class,
                'from_section_id' => $fromSection,
                'from_academic_year_id' => $request->from_academic_year,
                'previous_roll_number' => $previousRollNumber,

                'to_branch_id' => auth()->user()->branch_id,
                'to_shift_id' => $request->to_shift ?? null,
                'to_class_id' => $request->to_class,
                'to_section_id' => $toSection,
                'to_academic_year_id' => $request->to_academic_year,
                'to_roll_number' => $currentRollNumber ?? null,

                'is_active' => true,
            ];

            $studentInfoData = [
                'student_class_id' => $request->to_class,
                'section_id' => $toSection,
                'shift_id' => $request->to_shift ?? null,
                'group_id' => $group ?? null,
                'class_roll' => $currentRollNumber ?? null,
            ];

            if (!$existingPromotion) {

                // Create a new promotion record
                StudentPromotion::create($promotionData);

                // Update the student's class
                StudentInfo::where('id', $studentId)->update($studentInfoData);

                //Deactivate the old promotion record if it exists
                StudentPromotion::where('student_id', $studentId)
                    ->where('from_academic_year_id', $request->from_academic_year)
                    ->where('from_class_id', $request->from_class)
                    ->update(['is_active' => false]);
            } else {
                // Update existing records
                StudentPromotion::where('student_id', $studentId)
                    ->where('to_academic_year_id', $request->to_academic_year)
                    ->where('to_class_id', $request->to_class)
                    ->update($promotionData);
                StudentInfo::where('id', $studentId)->update($studentInfoData);
            }
        }
    }

    //get related data class, secction, shift

    public function getRelatedData()
    {
        $classes = StudentClass::pluck('class_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $academicYears = AcademicYear::pluck('year', 'id');
        $exams = Exam::orderBy('id', 'desc')->select('id','exam_name','year')->get();
        return compact('classes', 'shifts', 'groups', 'academicYears', 'exams');
    }


    public function updateMeritPositions(Request $request)
    {
        $fromClass = $request->from_class;
        $fromAcademicYear = $request->from_academic_year;
        $fromShift = $request->from_shift;
        $fromSection = $request->from_section;
        $currentActiveExam = Exam::where('is_published', true)->first();
    
        // Get assigned marks head for the class
        $assignedMarksHead = MarkHeadAssign::where('student_class_id', $fromClass)
            ->pluck('head_marks', 'subject_id')
            ->map(function($marks) {
                // Convert JSON string to array and sum all mark values
                $marksArray = json_decode($marks, true);
                return array_sum($marksArray);
            });

        // Get grades for comparison
        $grades = Grade::orderBy('mark_from')->get();
    
        // Get exam records with total marks
        $examRecords = ExamRecord::where('class_id', $fromClass)
            ->where('exam_id', $currentActiveExam->id)
            ->where('year', $fromAcademicYear)
            ->when($fromShift, function ($query) use ($fromShift) {
                $query->where('shift_id', $fromShift);
            })
            ->when($fromSection, function ($query) use ($fromSection) {
                $query->where('section_id', $fromSection);
            })
            ->get()
            ->groupBy('student_id');
    
        // Get student IDs from exam records
        $studentIdsWithRecords = $examRecords->keys();

        // Get students with their current positions
        $students = StudentInfo::whereIn('id', $studentIdsWithRecords)
            ->get();
    
        // Calculate student results
        $studentResults = [];
        foreach ($examRecords as $studentId => $records) {
            $totalMarks = $records->sum('total_marks');
            $totalAssignedMarks = 0;
            $failedSubjects = 0;
    
            foreach ($records as $record) {
                $totalAssignedMarks += $assignedMarksHead[$record->subject_id] ?? 0;
    
                // Calculate percentage for this subject
                $subjectPercentage = ($record->total_marks / ($assignedMarksHead[$record->subject_id] ?? 1)) * 100;
    
                // Find grade for this mark
                $grade = $grades->first(function($grade) use ($subjectPercentage) {
                    return $subjectPercentage >= $grade->mark_from && $subjectPercentage <= $grade->mark_to;
                });
    
                // Check if subject is failed (grade F)
                if ($grade && $grade->name === 'F') {
                    $failedSubjects++;
                }
            }
    
            $percentage = $totalAssignedMarks > 0 ? ($totalMarks / $totalAssignedMarks) * 100 : 0;
    
            $studentResults[$studentId] = [
                'total_marks' => $totalMarks,
                'total_assigned_marks' => $totalAssignedMarks,
                'percentage' => $percentage,
                'failed_subjects' => $failedSubjects
            ];
        }
    
        // Add result data to each student
        foreach ($students as $student) {
            $result = $studentResults[$student->id] ?? null;
            $student->total_marks = $result['total_marks'] ?? 0;
            $student->total_assigned_marks = $result['total_assigned_marks'] ?? 0;
            $student->avg_percentage = $result['percentage'] ?? 0;
            $student->failed_subjects = $result['failed_subjects'] ?? 0;
            $student->current_position = $student->class_roll ?? 'N/A';
    
            // Calculate result status
            if ($result) {
                $student->result_status = $result['failed_subjects'] > 0 ? 
                    "Fail ({$result['failed_subjects']} subjects)" : 'Pass';
            } else {
                $student->result_status = 'No Result';
            }
        }
    
        // Sort students by total marks and then by class roll for new positions
        $students = $students->sortByDesc(function($student) {
            return [$student->total_marks, -$student->class_roll]; // Sort by total marks and then by class roll (descending)
        });
    
        // Assign merit positions
        $position = 1;
        foreach ($students as $student) {
            $student->merit_position = $position++;
            StudentInfo::where('id', $student->id)->update(['class_roll' => $student->merit_position]);
        }

    }


    public function graduationStore(Request $request)
    {
        try{
            $student_ids = $request->student_ids;
            StudentInfo::whereIn('id', $student_ids)->update(['status' => Status::GRADUATED]);
            return true;
        }catch(\Exception $e){
            return false;
        }
    }


}
