<?php

namespace App\Traits;

use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;

trait LogsActivityTrait
{
    protected static $logAttributes = ['*'];
    protected static $logOnlyDirty = true;
    // protected static $logName = 'default';
    protected static $submitEmptyLogs = false;

    public function tapActivity(Activity $activity, string $eventName)
    {
        switch ($eventName) {
            case 'created':
                $activity->description = 'Created';
                break;
            case 'updated':
                $activity->description = 'Updated';
                break;
            case 'deleted':
                $activity->description = 'Deleted';
                break;
        }
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logOnlyDirty()
            ->setDescriptionForEvent(fn(string $eventName) => "{$this->logName()} has been {$eventName}")
            ->useLogName($this->logName());
    }

    protected function logName(): string
    {
        return 'default';
    }
}

