<?php

namespace App\View\Components;

use Closure;
use Illuminate\View\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;

class BranchAdmissionCard extends Component
{
    public $branchId;
    public $currentYearStudentCount;
    /**
     * Create a new component instance.
     */
    public function __construct($branchId)
    {
        $this->branchId = $branchId;

        // Count students for this branch
        $this->currentYearStudentCount = DB::table('student_infos')
    ->where('branch_id', $branchId)
    ->whereYear('created_at', date('Y'))
    ->count();

    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.branch-admission-card');
    }
}
