<?php

namespace App\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Facades\DB;

class BranchExpenseCard extends Component
{

    public $branchId;
    public $totalExpense;

    public function __construct($branchId)
    {
        $this->branchId = $branchId;

        $this->totalExpense = DB::table('expenses')
        ->where('branch_id', $branchId)
        ->whereBetween('expense_date', [
            now()->subDays(30)->toDateString(),
            now()->toDateString()
        ])
        ->sum('amount');
    }

    public function render()
    {
        return view('components.branch-expense-card');
    }

}
