<?php

namespace App\View\Components;

use Closure;
use Illuminate\View\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;

class BranchIncomeCard extends Component
{

    public $branchId;
    public $totalIncome;

    /**
     * Create a new component instance.
     */
    public function __construct($branchId)
    {
        $this->branchId = $branchId;

        $this->totalIncome = DB::table('incomes')
            ->where('branch_id', $branchId)
            ->whereBetween('income_date', [
                now()->subDays(30)->toDateString(),
                now()->toDateString()
            ])
            ->sum('amount');
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.branch-income-card');
    }
}
