<?php

namespace App\View\Components;

use Closure;
use Illuminate\View\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;

class BranchStudentCard extends Component
{
    public $branchId;
    public $studentCount;

    /**
     * Create a new component instance.
     */
    public function __construct($branchId)
    {
        $this->branchId = $branchId;

        // Count students for this branch
        $this->studentCount = DB::table('student_infos')
            ->where('branch_id', $branchId)
            ->count();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.branch-student-card');
    }
}
