<?php

namespace App\View\Components;

use Closure;
use Illuminate\View\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;

class BranchTeacherCard extends Component
{
    public $branchId;
    public $teacherCount;
    /**
     * Create a new component instance.
     */
    public function __construct($branchId)
    {
        $this->branchId = $branchId;

        // Count students for this branch
        $this->teacherCount = DB::table('employees')
            ->where('branch_id', $branchId)->where('user_type', 'teacher')
            ->count();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.branch-teacher-card');
    }
}
