<?php

namespace App\View\Components;

use App\Models\Result\Exam;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class DashboardPieChart extends Component
{
    public $exams;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->exams = Exam::select('id', 'exam_name', 'year')
            ->orderBy('id', 'desc')
            ->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.dashboard-pie-chart');
    }
}
