<?php

namespace App\View\Components;

use App\Models\Academic\Group;
use Illuminate\View\Component;
use Illuminate\View\View;

class GroupSelector extends Component
{

    public $name;
    public $label;
    public $labelText;
    public $groups;
    public $selected;
    public $student_class_id;
    public $required;
    public $col;

    /**
     * Create a new component instance.
     *
     * @param string $label
     * @param array $groups
     * @param mixed $selected
     */
    public function __construct($name, $label = null, $labelText = null, $groups = [], $student_class_id=null, $required = false,  $selected = null, $col = null)
    {
        $this->name = $name;
        $this->label = $label;
        $this->labelText = $labelText;
        $this->groups = empty($groups)
            ? Group::where('status', 1)->pluck('group_name', 'id')
            : $groups;
        $this->student_class_id = $student_class_id;
        $this->required = $required;
        $this->selected = $selected;
        $this->col = $col;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return View
     */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
    public function render(): View
    {
        return view('components.group-selector');
    }
}
