<?php

namespace App\View\Components;

use Illuminate\View\Component;
use Devfaysal\BangladeshGeocode\Models\District;
use Devfaysal\BangladeshGeocode\Models\Division;

class LocationDropdown extends Component
{
    public $divisions;
    public $districts;
    public $selectedDivision;
    public $selectedDistrict;
    public $selectedUpazila;
    public $selectedUnion;
    public $containerClass;
    public $groupClass;
    public $labelClass;
    public $selectClass;
    public $prefix;

    public function __construct(
        $selectedDivision = null,
        $selectedDistrict = null,
        $selectedUpazila = null,
        $selectedUnion = null,
        $containerClass = '',
        $groupClass = 'form-group',
        $labelClass = '',
        $selectClass = 'form-control',
        $prefix = ''
    ) {
        $this->divisions = Division::all();
        $this->districts = District::all();
        $this->selectedDivision = $selectedDivision;
        $this->selectedDistrict = $selectedDistrict;
        $this->selectedUpazila = $selectedUpazila;
        $this->selectedUnion = $selectedUnion;
        $this->containerClass = $containerClass;
        $this->groupClass = $groupClass;
        $this->labelClass = $labelClass;
        $this->selectClass = $selectClass;
        $this->prefix = $prefix ? $prefix . '_' : '';
    }

    public function render()
    {
        return view('components.location-dropdown');
    }
} 