<?php

namespace App\View\Composers;

use App\Models\Academic\Branch;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class NavbarComposer
{
    public function compose(View $view): void
    {
        $branch_data = Cache::remember('branch_data', 1440, function () {
            return Branch::pluck('branch_name', 'id')->toArray();
        });

        $view->with('branch_data', $branch_data);
    }
}
