<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sms_records', function (Blueprint $table) {
            $table->id();
            $table->string('send_from');
            $table->string('send_to');
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('student_id')->nullable();
            $table->unsignedBigInteger('exam_id')->nullable();
            $table->unsignedBigInteger('academic_year_id')->nullable();
            $table->mediumText('sms_text')->nullable();
            $table->double('sms_cost', 2, 2)->nullable();
            $table->tinyInteger('number_of_sms')->nullable();
            $table->enum('type',['general', 'student', 'employee']);
            $table->enum('status',['pending', 'failed', 'delivered']);
            $table->timestamp('send_time')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('created_by')->nullable();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sms_records');
    }
};