<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //opt and otp_expires_at column
            $table->string('otp')->after('remember_token')->nullable();
            $table->dateTime('otp_expires_at')->after('otp')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //drop otp and otp_expires_at column
            $table->dropColumn('otp');
            $table->dropColumn('otp_expires_at');
        });
    }
};
