<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_info_subject_class', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('student_info_id');
            $table->unsignedBigInteger('subject_id');
            $table->unsignedBigInteger('student_class_id');
            $table->enum('subject_type', ['compulsory', 'elective', 'optional'])->nullable();
            $table->timestamps();

            // Foreign Keys
            $table->foreign('student_info_id')->references('id')->on('student_infos')->onDelete('cascade');
            $table->foreign('subject_id')->references('id')->on('subjects')->onDelete('cascade');
            $table->foreign('student_class_id')->references('id')->on('student_classes')->onDelete('cascade');

            // Shorter, manually named unique constraint
            $table->unique(['student_info_id', 'subject_id', 'student_class_id'], 'unique_student_subject_class');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_info_subject_class');
    }
};
