<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('online_admissions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->boolean('selected')->default(false);
            $table->boolean('admitted')->default(false);
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('form_id');
            $table->unique(['branch_id', 'form_id']);
            // Basic Info
            $table->string('session',15)->nullable();
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->enum('gender', ['male', 'female', 'other'])->nullable();
            $table->string('blood_group')->nullable();
            $table->string('religion')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('birth_certi_no')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email')->nullable();
            $table->string('profile_image')->nullable();

            // Academic Info
            $table->bigInteger('shift_id')->nullable();
            $table->bigInteger('student_class_id')->nullable();

            // Guardian Info
            $table->string('father_name')->nullable();
            $table->bigInteger('father_occupation')->nullable();
            $table->string('father_mobile')->nullable();

            $table->string('mother_name')->nullable();
            $table->bigInteger('mother_occupation')->nullable();
            $table->string('mother_mobile')->nullable();

            $table->string('guardian_name')->nullable();
            $table->bigInteger('guardian_occupation')->nullable();
            $table->string('guardian_mobile')->nullable();
            $table->bigInteger('guardian_relationship')->nullable();
            $table->text('guardian_address')->nullable();

            // Addresses
            $table->bigInteger('present_division_id')->nullable();
            $table->bigInteger('present_district_id')->nullable();
            $table->bigInteger('present_upazila_id')->nullable();
            $table->text('present_address')->nullable();

            $table->bigInteger('permanent_division_id')->nullable();
            $table->bigInteger('permanent_district_id')->nullable();
            $table->bigInteger('permanent_upazila_id')->nullable();
            $table->text('permanent_address')->nullable();

            // Other Info
            $table->string('sibling_student_id_no')->nullable();

            // Previous Institute
            $table->string('previous_institute_name')->nullable();
            $table->string('previous_institute_address')->nullable();
            $table->string('previous_institute_tc_no')->nullable();
            $table->date('previous_institute_tc_date')->nullable();
            $table->string('previous_institute_tc')->nullable();

            $table->string('discount_type')->nullable();
            $table->string('discount_amount')->nullable();
            $table->string('total_amount')->nullable();
            $table->string('total_discount')->nullable();
            $table->string('grand_total')->nullable();
            $table->json('fee_details')->nullable();
            $table->string('month')->nullable();
            $table->date('invoice_date')->nullable();

            
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('online_admissions');
    }
};
