<?php

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fee_discounts', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('discount_code')->unique();
            $table->boolean('is_percentage')->default(false);
            $table->unsignedTinyInteger('percentage')->nullable(); // Percentage discount (0-100)
            $table->decimal('amount', 8, 2)->nullable(); // Fixed amount discount
            $table->text('note')->nullable();
            $table->string('status')->default(Status::ACTIVE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fee_discounts');
    }
};
