<?php

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->string('invoice_no')->nullable();
            $table->foreignId('academic_year_id')->nullable()->constrained('academic_years');
            $table->foreignId('branch_id')->nullable()->constrained('branches');
            $table->foreignId('shift_id')->nullable()->constrained('shifts');
            $table->foreignId('student_class_id')->nullable()->constrained('student_classes');
            $table->foreignId('section_id')->nullable()->constrained('sections');
            $table->foreignId('student_info_id')->nullable()->constrained('student_infos');
            $table->decimal('total_amount')->nullable();
            $table->decimal('total_discount')->nullable();
            $table->decimal('late_fine')->nullable();
            $table->decimal('paid_amount', 10, 2)->nullable();
            $table->timestamp('payment_date')->nullable();
            $table->date('invoice_date')->nullable();
            $table->date('due_date')->nullable();
            $table->string('payment_method')->nullable();
            $table->string('bank_transection_id')->nullable();
            $table->string('status')->default(Status::PAID);
            $table->string('note')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users', 'id');
            $table->foreignId('deleted_by')->nullable()->constrained('users', 'id');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::table('invoice_items', function (Blueprint $table) {
            if (Schema::hasColumn('invoice_items', 'invoice_id')) {
                $table->dropForeign(['invoice_id']); // Drop the foreign key only if it exists
                $table->dropColumn('invoice_id');   // Drop the column if it exists
            }
        });

        Schema::dropIfExists('invoices');
    }
};
