<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('student_fee_id');
            $table->foreignId('student_id')->nullable()->constrained('student_infos');
            $table->foreignId('invoice_id')->constrained('invoices');
            $table->foreignId('fee_type_id')->constrained('fee_types');
            $table->foreignId('academic_year_id')->nullable()->constrained('academic_years');
            $table->tinyInteger('month')->nullable();
            $table->decimal('amount', 8, 2);
            $table->decimal('discount', 8, 2);
            $table->date('payment_date')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    
        // Drop the table
        Schema::dropIfExists('invoice_items');
    }
};
