<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('check_books', function (Blueprint $table) {
            $table->id();
            $table->string('branch_id')->comment('branches.id')->nullable();
            $table->string('name');
            $table->string('account_no')->nullable();
            $table->string('routing_no')->nullable();
            $table->tinyInteger('total_page')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('check_books');
    }
};
