<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fee_invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->nullable()->constrained();
            $table->foreignId('student_id')->constrained('student_infos');
            $table->foreignId('student_class_id')->constrained('student_classes');
            $table->foreignId('section_id')->nullable()->constrained('sections');
            $table->foreignId('shift_id')->nullable()->constrained('shifts');
            $table->foreignId('fee_type_id')->constrained('fee_types');
            $table->decimal('amount', 10, 2);
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->tinyInteger('month')->nullable();
            $table->unsignedBigInteger('academic_year_id')->nullable();

            $table->timestamps();
        });
        
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fee_invoices');
    }
};
