<?php

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_fees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_id');
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('academic_year_id');
            $table->unsignedBigInteger('student_class_id');
            $table->unsignedBigInteger('student_id');
            $table->tinyInteger('month')->nullable();
            $table->decimal('total_amount', 10, 2);
            $table->decimal('total_discount', 10, 2);
            $table->decimal('grand_total', 10, 2);
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->string('status', 50)->default(Status::ACTIVE);
            $table->timestamps();
            
            // Add index for better query performance
            $table->index(['student_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_fees');
    }
};
