<?php

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('monthly_salaries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('employees');
            $table->foreignId('academic_year_id')->constrained('academic_years');
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->tinyInteger('month');
            $table->date('from_date')->nullable();
            $table->date('to_date')->nullable();
            $table->date('process_date')->nullable();
            $table->foreignId('salary_grade_id')->constrained('salary_grades');
            $table->decimal('amount', 10, 2)->nullable();
            $table->foreignId('given_by')->nullable()->constrained('users')->onDelete('set null');
            $table->string('status')->default(Status::DUE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monthly_salaries');
    }
};
