<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->unsignedBigInteger('present_division_id')->after('present_address')->nullable();
            $table->unsignedBigInteger('present_district_id')->after('present_division_id')->nullable();
            $table->unsignedBigInteger('present_upazila_id')->after('present_district_id')->nullable();
            $table->unsignedBigInteger('present_union_id')->after('present_upazila_id')->nullable();
            $table->unsignedBigInteger('permanent_division_id')->after('permanent_address')->nullable();
            $table->unsignedBigInteger('permanent_district_id')->after('permanent_division_id')->nullable();
            $table->unsignedBigInteger('permanent_upazila_id')->after('permanent_district_id')->nullable();
            $table->unsignedBigInteger('permanent_union_id')->after('permanent_upazila_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn('present_division_id');
            $table->dropColumn('present_district_id');
            $table->dropColumn('present_upazila_id');
            $table->dropColumn('present_union_id');
            $table->dropColumn('permanent_division_id');
            $table->dropColumn('permanent_district_id');
            $table->dropColumn('permanent_upazila_id');
            $table->dropColumn('permanent_union_id');
        });
    }
};
