<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hsc_admissions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->string('email')->nullable();
            $table->string('admission_roll')->nullable();
            $table->string('session_year')->nullable();
            $table->string('class_roll')->nullable();
            $table->string('merit_position')->nullable();
            $table->string('first_name')->nullable();
            $table->string('applicant_mobile')->nullable();
            $table->string('blood_group',10)->nullable();
            $table->string('nid',50)->nullable();
            $table->date('dob')->nullable();
            $table->string('marital_status',20)->nullable();
            $table->string('gender',20)->nullable();
            $table->string('nationality',20)->nullable();
            $table->string('religion',20)->nullable();
            $table->string('profile_image')->nullable();
            $table->string('board_select',50)->nullable();
            $table->string('passing_year',50)->nullable();
            $table->string('institute_name',250)->nullable();
            $table->string('ssc_roll_num',10)->nullable();
            $table->string('ssc_reg_num',30)->nullable();
            $table->string('ssc_session',50)->nullable();
            $table->string('ssc_gpa',50)->nullable();
            
            $table->string('main_subject1',10)->nullable();
            $table->string('main_subject2', 10)->nullable();
            $table->string('main_subject3', 10)->nullable();
            $table->string('main_subject4', 10)->nullable();
            $table->string('main_subject5', 10)->nullable();
            $table->string('elective_subject1', 10)->nullable();
            $table->string('elective_subject2', 10)->nullable();
            $table->string('elective_subject3', 10)->nullable();
            $table->string('optional_subject', 10)->nullable();

            $table->string('father_name',50)->nullable();
            $table->string('father_nid',50)->nullable();
            $table->date('father_dob',10)->nullable();
            $table->string('father_mobile',20)->nullable();
            $table->string('father_occupation',50)->nullable();
            $table->string('father_income',20)->nullable();

            $table->string('mother_name',50)->nullable();
            $table->string('mother_nid',50)->nullable();
            $table->date('mother_dob',10)->nullable();
            $table->string('mother_mobile',20)->nullable();
            $table->string('mother_occupation',30)->nullable();
            $table->string('mother_income',20)->nullable();

            $table->string('guardian_selection',50)->nullable();
            $table->string('guardian_name',30)->nullable();
            $table->string('gardian_nid',20)->nullable();
            $table->string('guardian_mobile',20)->nullable();
            $table->string('guardian_relation',250)->nullable();
            $table->string('guardian_address',250)->nullable();

            $table->string('same_as_present',20)->nullable();

            $table->string('special_quata')->nullable();
            $table->string('community')->nullable();

            $table->string('group_payment',50)->nullable();
            $table->string('payment_from_account',50)->nullable();
            $table->string('payment_amount',20)->nullable();
            $table->string('payment_tnxid',50)->nullable();

            $table->string('hscgruop',50)->nullable();


            $table->string('present_division_id', 100)->nullable();
            $table->string('present_district_id', 100)->nullable();
            $table->string('present_upazila_id', 100)->nullable();
            $table->string('present_union_id', 100)->nullable();
            $table->string('present_address', 255)->nullable();

            $table->string('permanent_division_id', 100)->nullable();
            $table->string('permanent_district_id', 100)->nullable();
            $table->string('permanent_upazila_id', 100)->nullable();
            $table->string('permanent_union_id', 100)->nullable();
            $table->boolean('selected')->default(false);
            


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hsc_admissions');
    }
};
