<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transaction_master', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('student_id')->nullable();
            $table->BigInteger('invoice_number')->unique(); 
            $table->enum('transaction_type', ['sale', 'purchase']);
            $table->date('transaction_date')->nullable();
            $table->decimal('total_amount', 10, 2);
            $table->decimal('total_discount', 10, 2)->nullable();
            $table->decimal('grand_total', 10, 2)->nullable()->comment('Total amount after discount');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions_summary');
    }
}; 