<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booklists', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('book_number')->nullable();
            $table->string('isbn_number')->nullable();
            $table->string('publisher')->nullable();
            $table->string('author')->nullable();
            $table->string('subject')->nullable();
            $table->string('rack_number')->nullable();
            $table->integer('quantity')->default(0);
            $table->integer('price')->nullable();
            $table->date('postdate')->nullable();
            $table->text('description')->nullable();
            $table->boolean('status')->nullable()->default(true);
            $table->timestamps();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booklists');
    }
};
