<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_promotions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('student_id');

            $table->unsignedBigInteger('from_branch_id')->nullable();
            $table->unsignedBigInteger('from_shift_id')->nullable();
            $table->unsignedBigInteger('from_academic_year_id')->nullable();
            // $table->unsignedBigInteger('from_department_id')->nullable();
            $table->unsignedBigInteger('from_class_id')->nullable();
            $table->unsignedBigInteger('from_section_id')->nullable();
            $table->unsignedBigInteger('previous_roll_number')->nullable();

            $table->unsignedBigInteger('to_branch_id')->nullable();
            $table->unsignedBigInteger('to_shift_id')->nullable();
            $table->unsignedBigInteger('to_academic_year_id')->nullable();
            // $table->unsignedBigInteger('to_department_id')->nullable();
            $table->unsignedBigInteger('to_class_id')->nullable();
            $table->unsignedBigInteger('to_section_id')->nullable();
            $table->unsignedBigInteger('to_roll_number')->nullable();
            
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_promotions');
    }
};
