<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AcademicYearsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Temporarily disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('academic_years')->truncate();
        // Enable foreign key checks again
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        DB::table('academic_years')->insert([
            [
                'year' => '2023',
                'is_default_year' => 'no',
                'status' =>  '1',
                'created_at' => now()
            ],
            [
                'year' => '2024',
                'is_default_year' => 'no',
                'status' =>  '1',
                'created_at' => now()
            ],
            [
                'year' => '2025',
                'is_default_year' => 'yes',
                'status' =>  '1',
                'created_at' => now()
            ],
            [
                'year' => '2026',
                'is_default_year' => 'no',
                'status' =>  '1',
                'created_at' => now()
            ]
        ]);
    }
}
