<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\Academic\Branch;
use App\Models\Accounting\AccountingHead;

class AccountingHeadSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = Carbon::now();

        //disable foreign key check
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        DB::table('accounting_heads')->truncate();
        //enable foreign key check
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');

        $branches = Branch::get();
        
        foreach ($branches as $branch) {
            // Income heads
            $incomeHeads = [
                ['name' => 'ট্রাস্ট হতে প্রাপ্ত', 'slug' => Str::slug('ট্রাস্ট হতে প্রাপ্ত'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'ক্যাশ বুক গ্রাহক হতে প্রাপ্ত', 'slug' => Str::slug('ক্যাশ বুক গ্রাহক হতে প্রাপ্ত'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'হিফয পুরুষ বেতন', 'slug' => Str::slug('হিফয পুরুষ বেতন'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'নুরানী বিভাগ বেতন', 'slug' => Str::slug('নুরানী বিভাগ বেতন'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বই বিক্রয়', 'slug' => Str::slug('বই বিক্রয়'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'পরিবহণ ভাড়া বাবদ', 'slug' => Str::slug('পরিবহণ ভাড়া বাবদ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'ঋণ গ্রহণ', 'slug' => Str::slug('ঋণ গ্রহণ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'ছাত্রের চাঁদা', 'slug' => Str::slug('ছাত্রের চাঁদা'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'নুরানী ভর্তি', 'slug' => Str::slug('নুরানী ভর্তি'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'হিফয ভর্তি', 'slug' => Str::slug('হিফয ভর্তি'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'সূধী সমাবেশ', 'slug' => Str::slug('সূধী সমাবেশ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'সবক প্রদান অনুষ্ঠান', 'slug' => Str::slug('সবক প্রদান অনুষ্ঠান'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'পোষক বাবদ', 'slug' => Str::slug('পোষক বাবদ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'সিলেবাস বাবদ', 'slug' => Str::slug('সিলেবাস বাবদ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'income', 'created_at' => $now, 'updated_at' => $now],
            ];

            // Expense heads
            $expenseHeads = [
                ['name' => 'হোস্টেল ১', 'slug' => Str::slug('হোস্টেল ১'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'হোস্টেল ২', 'slug' => Str::slug('হোস্টেল ২'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'টিফিন ১', 'slug' => Str::slug('টিফিন ১'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'টিফিন ২', 'slug' => Str::slug('টিফিন ২'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'সম্পদ', 'slug' => Str::slug('সম্পদ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'অফিস স্টেশনারী', 'slug' => Str::slug('অফিস স্টেশনারী'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বিল্ডিং মেরামত খরচ', 'slug' => Str::slug('বিল্ডিং মেরামত খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'যাতায়াত', 'slug' => Str::slug('যাতায়াত'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'আপ্যায়ন খরচ', 'slug' => Str::slug('আপ্যায়ন খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'টেলিফোন ও ইন্টারনেট বিল', 'slug' => Str::slug('টেলিফোন ও ইন্টারনেট বিল'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'প্রচার প্রচারণা খরচ', 'slug' => Str::slug('প্রচার প্রচারণা খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'অফিস ভাড়া', 'slug' => Str::slug('অফিস ভাড়া'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বিদ্যুৎ বিল', 'slug' => Str::slug('বিদ্যুৎ বিল'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বেতন ভাতা', 'slug' => Str::slug('বেতন ভাতা'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'অফিস মেরামত খরচ', 'slug' => Str::slug('অফিস মেরামত খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'সভা সমাবেশ', 'slug' => Str::slug('সভা সমাবেশ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বিবিধ খরচ', 'slug' => Str::slug('বিবিধ খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বই ক্রয়', 'slug' => Str::slug('বই ক্রয়'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'ট্রাস্ট কে প্রদান', 'slug' => Str::slug('ট্রাস্ট কে প্রদান'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'ক্যাশ বুক গ্রাহক প্রদান', 'slug' => Str::slug('ক্যাশ বুক গ্রাহক প্রদান'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'গাড়ি ক্রয়', 'slug' => Str::slug('গাড়ি ক্রয়'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'গাড়ির তেল', 'slug' => Str::slug('গাড়ির তেল'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'গাড়ির মেরামত খরচ', 'slug' => Str::slug('গাড়ির মেরামত খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'বাসার ট্যাক্স', 'slug' => Str::slug('বাসার ট্যাক্স'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
                ['name' => 'চিকিৎসা ও ঔষধ খরচ', 'slug' => Str::slug('চিকিৎসা ও ঔষধ খরচ'.'-'.$branch->id), 'branch_id' => $branch->id, 'type' => 'expense', 'created_at' => $now, 'updated_at' => $now],
            ];

            AccountingHead::insert($incomeHeads);
            AccountingHead::insert($expenseHeads);
        }




    }
} 