<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BookissueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $chunkSize = 1000; // Number of records per insert
        $totalRecords = 100; // Total records to insert

        for ($i = 0; $i < $totalRecords / $chunkSize; $i++) {
            $data = [];

            for ($j = 0; $j < $chunkSize; $j++) {
                $data[] = [
                    'user_id' => 11,
                    'booklist_id' => 3,
                    'bookmember_id' => 3,
                    'issue_date' => now(), // Fixed the issue
                    'estimate_return_date' => now(), // Fixed the issue
                    'status' => 'issued',
                    'created_by' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
            }

            DB::table('bookissues')->insert($data);
            echo "Inserted chunk " . ($i + 1) . " of " . ($totalRecords / $chunkSize) . "\n";
        }
    }
}
