<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
class EmployeeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $min = strtotime("jan 1st -47 years");
        $max = strtotime("dec 31st -18 years");
        $time = rand($min,$max);
        $dob = date("Y-m-d",$time);
        //  Temporarily disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('employees')->truncate();
        //  Enable foreign key checks again
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        DB::table('employees')->insert([
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'male',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'female',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'male',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'male',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'female',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'male',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'female',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'branch_id' => rand(1,3),
                'shift_id' => rand(1,2),
                'first_name' => Str::random(5),
                'last_name' => Str::random(5),
                'father_name' => Str::random(5),
                'mother_name' => Str::random(5),
                'blood_group' => 'A+',
                'date_of_birth' => $dob,
                'gender' => 'male',
                'mobile_number' => rand(1000,9999),
                'email' => Str::random(1).'@gmail.com',
                'joining_date' => date('Y-m-d'),
                'education_info' => Str::random(20),
                'present_address' => Str::random(20),
                'permanent_address' => Str::random(20),
                'bank_ac_no' => rand(1000,9999),
                'salary' => rand(10000,999999),
                'employee_type_id' => rand(1,4),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],

        ]);
    }
}
