<?php

namespace Database\Seeders;

use App\Constants\Status;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EmployeeTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('employee_types')->truncate();
        $employeeTypes = [
            [
                'emp_type' => 'Full Time',
                'status' => Status::ACTIVE,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'emp_type' => 'Part Time',
                'status' => Status::ACTIVE,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'emp_type' => 'Provision',
                'status' => Status::ACTIVE,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'emp_type' => 'Trainee',
                'status' => Status::ACTIVE,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'emp_type' => 'Intern',
                'status' => Status::ACTIVE,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];
        DB::table('employee_types')->insert($employeeTypes);
    }
}
