<?php

namespace Database\Seeders;

use App\Models\Accounting\FeeCycleType;
use Illuminate\Database\Seeder;

class FeeCycleTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $feeCycleTypes = [
            [
                'name' => 'Every Month',
                'cycle_count' => 1,
                'sequence' => 1,
                'created_at' => now(),
            ],
            [
                'name' => 'After Two Month',
                'cycle_count' => 2,
                'sequence' => 2,
                'created_at' => now(),
            ],
            [
                'name' => 'After Three Month',
                'cycle_count' => 3,
                'sequence' => 3,
                'created_at' => now(),
            ],
            [
                'name' => 'After Four Month',
                'cycle_count' => 4,
                'sequence' => 4,
                'created_at' => now(),
            ],
            [
                'name' => 'After Six Month',
                'cycle_count' => 6,
                'sequence' => 5,
                'created_at' => now(),
            ],
            [
                'name' => 'Yearly Once',
                'cycle_count' => 12,
                'sequence' => 12,
                'created_at' => now(),
            ],
        ];

        FeeCycleType::insert($feeCycleTypes);

    }
}
