<?php

namespace Database\Seeders;

use Illuminate\Support\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GuardianRelationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        
        DB::table('guardian_relations')->truncate();
        $now = Carbon::now();

        $relations = [
            'Father',
            'Mother',
            'Grandfather',
            'Grandmother',
            'Sister',
            'Brother',
            'Uncle',
            'Aunty',
            'Maternal Uncle',
            'Brother in Law',
        ];

        foreach ($relations as $relation) {
            DB::table('guardian_relations')->updateOrInsert(
                ['name' => $relation],
                [
                    'status' => 'active',
                    'created_at' => $now,
                    'updated_at' => $now,
                ]
            );
        }
        
    }
}
