<?php

namespace Database\Seeders;

use App\Models\HrPayroll\LeaveType;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LeaveTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('leave_types')->truncate();
        $salaryHeads = [
            [
                'name' => 'Casual Leave',
                'short_name' => 'CL',
                'allocated_days' => 10,
            ],
            [
                'name' => 'Sick Leave',
                'short_name' => 'SL',
                'allocated_days' => 18,
            ],
            [
                'name' => 'Earn Leave',
                'short_name' => 'EL',
                'allocated_days' => 14,
            ],
            [
                'name' => 'Leave Without Pay',
                'short_name' => 'LWP',
                'allocated_days' => 0,
            ],
        ];


        LeaveType::insert($salaryHeads);
    }
}
