<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class PermissionSeeder extends Seeder
{
    public function run()
    {
        $now = Carbon::now();
        
        $permissions = [
            [
                'name' => 'dashboard',
                'display_name' => 'Dashboard',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.todays-collection',
                'display_name' => 'Today\'s Collection',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.this-month-collection',
                'display_name' => 'This Month Collection',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.this-month-due',
                'display_name' => 'This Month Due',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.this-month-income',
                'display_name' => 'This Month Income',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.this-month-expense',
                'display_name' => 'This Month Expense',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.month-wise-income',
                'display_name' => 'Month Wise Income',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.month-wise-expense',
                'display_name' => 'Month Wise Expense',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            //total student
            [
                'name' => 'dashboard.dashboard-item.total-student',
                'display_name' => 'Total Student',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.total-teacher',
                'display_name' => 'Total Teacher',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.total-employee',
                'display_name' => 'Total Employee',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            //quick link
            [
                'name' => 'dashboard.dashboard-item.quick-link',
                'display_name' => 'Quick Link',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.yearly-collection-bar-chart',
                'display_name' => 'Yearly Collection Bar Chart',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.income-expense-pie-chart',
                'display_name' => 'Income Expense Pie Chart',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'dashboard.dashboard-item.student-list',
                'display_name' => 'Student List',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Academic Management (order: 1)
            [
                'name' => 'academic',
                'display_name' => 'Academic Management',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.branches.view',
                'display_name' => 'View Branches',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.branches.create',
                'display_name' => 'Create Branch',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.branches.edit',
                'display_name' => 'Edit Branch',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.branches.delete',
                'display_name' => 'Delete Branch',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.department.view',
                'display_name' => 'View Departments',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.department.create',
                'display_name' => 'Create Department',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.department.edit',
                'display_name' => 'Edit Department',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.department.delete',
                'display_name' => 'Delete Department',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.shifts.view',
                'display_name' => 'View Shifts',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.shifts.create',
                'display_name' => 'Create Shift',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.shifts.edit',
                'display_name' => 'Edit Shift',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.shifts.delete',
                'display_name' => 'Delete Shift',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.sections.view',
                'display_name' => 'View Sections',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.sections.create',
                'display_name' => 'Create Section',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.sections.edit',
                'display_name' => 'Edit Section',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.sections.delete',
                'display_name' => 'Delete Section',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.buildings.view',
                'display_name' => 'View Buildings',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.buildings.create',
                'display_name' => 'Create Building',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.buildings.edit',
                'display_name' => 'Edit Building',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.buildings.delete',
                'display_name' => 'Delete Building',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.building_floors.view',
                'display_name' => 'View Building Floors',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.building_floors.create',
                'display_name' => 'Create Building Floor',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.building_floors.edit',
                'display_name' => 'Edit Building Floor',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.building_floors.delete',
                'display_name' => 'Delete Building Floor',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class_rooms.view',
                'display_name' => 'View Class Rooms',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class_rooms.create',
                'display_name' => 'Create Class Room',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class_rooms.edit',
                'display_name' => 'Edit Class Room',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class_rooms.delete',
                'display_name' => 'Delete Class Room',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.student-class.view',
                'display_name' => 'View Student Classes',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.student-class.create',
                'display_name' => 'Create Student Class',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.student-class.edit',
                'display_name' => 'Edit Student Class',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.student-class.delete',
                'display_name' => 'Delete Student Class',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.groups.view',
                'display_name' => 'View Groups',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.groups.create',
                'display_name' => 'Create Group',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.groups.edit',
                'display_name' => 'Edit Group',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.groups.delete',
                'display_name' => 'Delete Group',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.academic-year.view',
                'display_name' => 'View Academic Year',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.academic-year.create',
                'display_name' => 'Create Academic Year',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.academic-year.edit',
                'display_name' => 'Edit Academic Year',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.academic-year.delete',
                'display_name' => 'Delete Academic Year',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-list.view',
                'display_name' => 'View Subjects List',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-list.create',
                'display_name' => 'Create Subject',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-list.edit',
                'display_name' => 'Edit Subject',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-list.delete',
                'display_name' => 'Delete Subject',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-assigns.view',
                'display_name' => 'View Subject Assigns',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-assigns.create',
                'display_name' => 'Create Subject Assign',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-assigns.edit',
                'display_name' => 'Edit Subject Assign',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.subjects-assigns.delete',
                'display_name' => 'Delete Subject Assign',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class-routine.view',
                'display_name' => 'View Class Routine',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class-routine.create',
                'display_name' => 'Create Class Routine',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class-routine.edit',
                'display_name' => 'Edit Class Routine',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.class-routine.delete',
                'display_name' => 'Delete Class Routine',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.assign-class-teacher.create',
                'display_name' => 'Create Assign Class Teacher',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.assign-class-teacher.edit',
                'display_name' => 'Edit Assign Class Teacher',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.assign-class-teacher.delete',
                'display_name' => 'Delete Assign Class Teacher',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.teacher-enroll.view',
                'display_name' => 'View Teacher Enroll',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.teacher-enroll.create',
                'display_name' => 'Create Teacher Enroll',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.teacher-enroll.edit',
                'display_name' => 'Edit Teacher Enroll',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'academic.teacher-enroll.delete',
                'display_name' => 'Delete Teacher Enroll',
                'guard_name' => 'web',
                'orders' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Student Management (order: 3)
            [
                'name' => 'student',
                'display_name' => 'Student Management',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.student-list.view',
                'display_name' => 'View Student List',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.student-list.create',
                'display_name' => 'Create Student',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.student-list.edit',
                'display_name' => 'Edit Student',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.student-list.delete',
                'display_name' => 'Delete Student',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.promotion.create',
                'display_name' => 'Student Promotion',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.graduation.create',
                'display_name' => 'Graduation',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.import.view',
                'display_name' => 'Import Student',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.id-card.view',
                'display_name' => 'Student ID Card',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.occupation.view',
                'display_name' => 'Guardian Occupation',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'student.relations.view',
                'display_name' => 'Guardian Relation',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],

            //Teacher Management (order: 2)
            [
                'name' => 'teacher',
                'display_name' => 'Teacher Management',
                'guard_name' => 'web',
                'orders' => 2,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'teacher.teacher-list.view',
                'display_name' => 'View Teacher List',
                'guard_name' => 'web',
                'orders' => 2,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'teacher.teacher-list.create',
                'display_name' => 'Create Teacher',
                'guard_name' => 'web',
                'orders' => 2,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'teacher.teacher-list.edit',
                'display_name' => 'Edit Teacher',
                'guard_name' => 'web',
                'orders' => 2,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'teacher.teacher-list.delete',
                'display_name' => 'Delete Teacher',
                'guard_name' => 'web',
                'orders' => 2,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Exam & Result (order: 4)
            [
                'name' => 'exam-result',
                'display_name' => 'Exam & Result',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.grade.view',
                'display_name' => 'View Grade Point',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.grade.create',
                'display_name' => 'Create Grade',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.grade.edit',
                'display_name' => 'Edit Grade',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.grade.delete',
                'display_name' => 'Delete Grade',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.exam-list.view',
                'display_name' => 'View Exam List',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.exam-list.create',
                'display_name' => 'Create Exam',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.exam-list.edit',
                'display_name' => 'Edit Exam',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.exam-list.delete',
                'display_name' => 'Delete Exam',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.mark-head.view',
                'display_name' => 'View Mark Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.mark-head.create',
                'display_name' => 'Create Mark Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.mark-head.edit',
                'display_name' => 'Edit Mark Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.mark-head.delete',
                'display_name' => 'Delete Mark Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.assign-head.view',
                'display_name' => 'View Assign Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.assign-head.create',
                'display_name' => 'Create Assign Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.assign-head.edit',
                'display_name' => 'Edit Assign Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.assign-head.delete',
                'display_name' => 'Delete Assign Head',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.marks-list.view',
                'display_name' => 'View Marks List',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.marks-list.create',
                'display_name' => 'Create Marks',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.marks-list.edit',
                'display_name' => 'Edit Marks',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.publish-result.view',
                'display_name' => 'View Publish Result',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.publish-result.create',
                'display_name' => 'Create Publish Result',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'exam-result.marks-sheet.view',
                'display_name' => 'View Marks Sheet',
                'guard_name' => 'web',
                'orders' => 4,
                'created_at' => $now,
                'updated_at' => $now
            ],

            [
                'name' => 'exam-result.admit-card.view',
                'display_name' => 'Admit Card',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],


            [
                'name' => 'exam-result.seat-plan.view',
                'display_name' => 'Seat Plan View',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],

            [
                'name' => 'exam-result.seat-plan.filter',
                'display_name' => 'Seat Plan Filter',
                'guard_name' => 'web',
                'orders' => 3,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Attendance (order: 5)
            [
                'name' => 'attendance',
                'display_name' => 'Student Attendance',
                'guard_name' => 'web',
                'orders' => 5,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'attendance.student.my-student',
                'display_name' => 'My Student Attendance',
                'guard_name' => 'web',
                'orders' => 5,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'attendance.student.create',
                'display_name' => 'Others Attendance',
                'guard_name' => 'web',
                'orders' => 5,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'attendance.report.view',
                'display_name' => 'Attendance Report',
                'guard_name' => 'web',
                'orders' => 5,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Accounting (order: 6)
            [
                'name' => 'accounting',
                'display_name' => 'Accounting & Finance',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.fees-type.view',
                'display_name' => 'View Fees Category',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.fees-type.create',
                'display_name' => 'Create Fees Category',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.fees-type.edit',
                'display_name' => 'Edit Fees Category',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.fees-type.delete',
                'display_name' => 'Delete Fees Category',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.class-wise-fees.view',
                'display_name' => 'View Fees Setup',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.class-wise-fees.create',
                'display_name' => 'Create Fees Setup',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.class-wise-fees.edit',
                'display_name' => 'Edit Fees Setup',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.class-wise-fees.delete',
                'display_name' => 'Delete Fees Setup',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.fees-discount.view',
                'display_name' => 'View Fees Discount',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.fees-discount.create',
                'display_name' => 'Create Fees Discount',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.collect-fees.view',
                'display_name' => 'Collect Fees',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.collect-fees.create',
                'display_name' => 'Collect Fees',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.collect-fees.edit',
                'display_name' => 'Edit Collect Fees',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.collect-fees.delete',
                'display_name' => 'Delete Collect Fees',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.due-list.view',
                'display_name' => 'Due Fees',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.accounting-head.view',
                'display_name' => 'View Accounting Head',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.accounting-head.create',
                'display_name' => 'Create Accounting Head',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.accounting-head.edit',
                'display_name' => 'Edit Accounting Head',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.accounting-head.delete',
                'display_name' => 'Delete Accounting Head',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.income.view',
                'display_name' => 'View Income',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.income.create',
                'display_name' => 'Create Income',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.income.edit',
                'display_name' => 'Edit Income',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.income.delete',
                'display_name' => 'Delete Income',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.expense.view',
                'display_name' => 'View Expense',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.expense.create',
                'display_name' => 'Create Expense',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.expense.edit',
                'display_name' => 'Edit Expense',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.expense.delete',
                'display_name' => 'Delete Expense',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-account.view',
                'display_name' => 'View Bank Account',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-account.create',
                'display_name' => 'Create Bank Account',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-account.edit',
                'display_name' => 'Edit Bank Account',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-account.delete',
                'display_name' => 'Delete Bank Account',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-deposit.view',
                'display_name' => 'View Bank Deposit',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-deposit.create',
                'display_name' => 'Create Bank Deposit',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-deposit.edit',
                'display_name' => 'Edit Bank Deposit',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-deposit.delete',
                'display_name' => 'Delete Bank Deposit',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-withdraw.view',
                'display_name' => 'View Bank Withdraw',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-withdraw.create',
                'display_name' => 'Create Bank Withdraw',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-withdraw.edit',
                'display_name' => 'Edit Bank Withdraw',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'accounting.bank-withdraw.delete',
                'display_name' => 'Delete Bank Withdraw',
                'guard_name' => 'web',
                'orders' => 6,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // SMS Management (order: 6)
            [
                'name' => 'sms-management',
                'display_name' => 'SMS Management',
                'guard_name' => 'web',
                'orders' => 7,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'sms-management.general-sms.create',
                'display_name' => 'General SMS',
                'guard_name' => 'web',
                'orders' => 7,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'sms-management.student-sms.create',
                'display_name' => 'Student SMS',
                'guard_name' => 'web',
                'orders' => 7,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'sms-management.employee-sms.create',
                'display_name' => 'Employee SMS',
                'guard_name' => 'web',
                'orders' => 7,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'sms-management.sms-report.view',
                'display_name' => 'SMS Reports',
                'guard_name' => 'web',
                'orders' => 7,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // HR & Payroll (order: 8)
            [
                'name' => 'hr-payroll',
                'display_name' => 'HR & Payroll',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.designation.view',
                'display_name' => 'View Designation',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.designation.create',
                'display_name' => 'Create Designation',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.designation.edit',
                'display_name' => 'Edit Designation',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.designation.delete',
                'display_name' => 'Delete Designation',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.department.view',
                'display_name' => 'View Department',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.department.create',
                'display_name' => 'Create Department',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.department.edit',
                'display_name' => 'Edit Department',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.department.delete',
                'display_name' => 'Delete Department',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employee-type.view',
                'display_name' => 'View Employee Types',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employee-type.create',
                'display_name' => 'Create Employee Types',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employee-type.edit',
                'display_name' => 'Edit Employee Types',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employee-type.delete',
                'display_name' => 'Delete Employee Types',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employees.view',
                'display_name' => 'View Employees',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employees.create',
                'display_name' => 'Create Employees',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employees.edit',
                'display_name' => 'Edit Employees',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employees.delete',
                'display_name' => 'Delete Employees',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-setting.view',
                'display_name' => 'View Salary Setting',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-head.view',
                'display_name' => 'View Salary Head',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-head.create',
                'display_name' => 'Create Salary Head',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-head.edit',
                'display_name' => 'Edit Salary Head',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-head.delete',
                'display_name' => 'Delete Salary Head',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-grade.view',
                'display_name' => 'View Salary Grade',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-grade.create',
                'display_name' => 'Create Salary Grade',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-grade.edit',
                'display_name' => 'Edit Salary Grade',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.salary-grade.delete',
                'display_name' => 'Delete Salary Grade',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.employee-salary.view',
                'display_name' => 'View Employee Salary',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.monthly-salary.view',
                'display_name' => 'View Monthly Salary',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leave-type.view',
                'display_name' => 'View Leave Type',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leave-type.create',
                'display_name' => 'Create Leave Type',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leave-type.edit',
                'display_name' => 'Edit Leave Type',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leave-type.delete',
                'display_name' => 'Delete Leave Type',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves.view',
                'display_name' => 'View Leave',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves.create',
                'display_name' => 'Create Leave',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves.edit',
                'display_name' => 'Edit Leave',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves.delete',
                'display_name' => 'Delete Leave',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves-request.view',
                'display_name' => 'View Leave Request',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves-request.create',
                'display_name' => 'Create Leave Request',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves-request.edit',
                'display_name' => 'Edit Leave Request',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.leaves-request.delete',
                'display_name' => 'Delete Leave Request',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hr-payroll.attendance.view',
                'display_name' => 'Attendance',
                'guard_name' => 'web',
                'orders' => 8,
                'created_at' => $now,
                'updated_at' => $now
            ],

            

            // Transport Management (order: 9)
            [
                'name' => 'transport-management',
                'display_name' => 'Transport Management',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.vehicles.view',
                'display_name' => 'View Vehicles',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.vehicles.create',
                'display_name' => 'Create Vehicles',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.vehicles.edit',
                'display_name' => 'Edit Vehicles',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.vehicles.delete',
                'display_name' => 'Delete Vehicles',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.routes.view',
                'display_name' => 'View Routes',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.routes.create',
                'display_name' => 'Create Routes',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.routes.edit',
                'display_name' => 'Edit Routes',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.routes.delete',
                'display_name' => 'Delete Routes',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.stoppage.view',
                'display_name' => 'View Stoppages',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.stoppage.create',
                'display_name' => 'Create Stoppages',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.stoppage.edit',
                'display_name' => 'Edit Stoppages',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.stoppage.delete',
                'display_name' => 'Delete Stoppages',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.assign-student.view',
                'display_name' => 'Assign Transport',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'transport-management.multiple-assign-student.create',
                'display_name' => 'Multi Student Assign',
                'guard_name' => 'web',
                'orders' => 9,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Hostel Management (order: 10)
            [
                'name' => 'hostel-management',
                'display_name' => 'Hostel Management',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostels.view',
                'display_name' => 'View Hostels',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostels.create',
                'display_name' => 'Create Hostels',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostels.edit',
                'display_name' => 'Edit Hostels',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostels.delete',
                'display_name' => 'Delete Hostels',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.room-type.view',
                'display_name' => 'View Room Type',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.room-type.create',
                'display_name' => 'Create Room Type',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.room-type.edit',
                'display_name' => 'Edit Room Type',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.room-type.delete',
                'display_name' => 'Delete Room Type',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostel-room.view',
                'display_name' => 'View Hostel Room',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.multiple-assign.create',
                'display_name' => 'Multiple Student Assign',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostel-room.create',
                'display_name' => 'Create Hostel Room',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostel-room.edit',
                'display_name' => 'Edit Hostel Room',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hostel-management.hostel-room.delete',
                'display_name' => 'Delete Hostel Room',
                'guard_name' => 'web',
                'orders' => 10,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // Library Management (order: 11)
            [
                'name' => 'library-management',
                'display_name' => 'Library Management',
                'guard_name' => 'web',
                'orders' => 11,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'library-management.books.view',
                'display_name' => 'View Book List',
                'guard_name' => 'web',
                'orders' => 11,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'library-management.member.create',
                'display_name' => 'Add Member',
                'guard_name' => 'web',
                'orders' => 11,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'library-management.books.issue',
                'display_name' => 'Issue/Return Book',
                'guard_name' => 'web',
                'orders' => 11,
                'created_at' => $now,
                'updated_at' => $now
            ],


            //Syllabus Plan (order: 12)
            [
                'name' => 'syllabus-plan',
                'display_name' => 'Syllabus Plan',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.lesson.view',
                'display_name' => 'View Lesson',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.lesson.create',
                'display_name' => 'Create Lesson',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.lesson.edit',
                'display_name' => 'Edit Lesson',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.lesson.delete',
                'display_name' => 'Delete Lesson',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.topic.view',
                'display_name' => 'View Topic',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.topic.create',
                'display_name' => 'Create Topic',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.topic.edit',
                'display_name' => 'Edit Topic',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.topic.delete',
                'display_name' => 'Delete Topic',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.status.view',
                'display_name' => 'View Syllabus Status',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.status.create',
                'display_name' => 'Create Syllabus Status',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.status.edit',
                'display_name' => 'Edit Syllabus Status',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'syllabus-plan.status.delete',
                'display_name' => 'Delete Syllabus Status',
                'guard_name' => 'web',
                'orders' => 12,
                'created_at' => $now,
                'updated_at' => $now
            ],


            //Homework (order: 13)
            [
                'name' => 'homework',
                'display_name' => 'Homework',
                'guard_name' => 'web',
                'orders' => 13,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'homework.homework.view',
                'display_name' => 'View Homework',
                'guard_name' => 'web',
                'orders' => 13,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'homework.homework.create',
                'display_name' => 'Create Homework',
                'guard_name' => 'web',
                'orders' => 13,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'homework.homework.edit',
                'display_name' => 'Edit Homework',
                'guard_name' => 'web',
                'orders' => 13,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'homework.homework.delete',
                'display_name' => 'Delete Homework',
                'guard_name' => 'web',
                'orders' => 13,
                'created_at' => $now,
                'updated_at' => $now
            ],

            //Holiday (order: 14)
            [
                'name' => 'holiday',
                'display_name' => 'Holiday',
                'guard_name' => 'web',
                'orders' => 14,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'holiday.holiday.view',
                'display_name' => 'View Holiday',
                'guard_name' => 'web',
                'orders' => 14,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'holiday.holiday.create',
                'display_name' => 'Create Holiday',
                'guard_name' => 'web',
                'orders' => 14,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'holiday.holiday.edit',
                'display_name' => 'Edit Holiday',
                'guard_name' => 'web',
                'orders' => 14,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'holiday.holiday.delete',
                'display_name' => 'Delete Holiday',
                'guard_name' => 'web',
                'orders' => 14,
                'created_at' => $now,
                'updated_at' => $now
            ],

            //Notice (order: 15)
            [
                'name' => 'notice',
                'display_name' => 'Notice',
                'guard_name' => 'web',
                'orders' => 15,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'notice.notice.view',
                'display_name' => 'View Notice',
                'guard_name' => 'web',
                'orders' => 15,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'notice.notice.create',
                'display_name' => 'Create Notice',
                'guard_name' => 'web',
                'orders' => 15,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'notice.notice.edit',
                'display_name' => 'Edit Notice',
                'guard_name' => 'web',
                'orders' => 15,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'notice.notice.delete',
                'display_name' => 'Delete Notice',
                'guard_name' => 'web',
                'orders' => 15,
                'created_at' => $now,
                'updated_at' => $now
            ],

            //Certificate (order: 16)
            [
                'name' => 'certificate',
                'display_name' => 'Certificate',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.templates.view',
                'display_name' => 'View Template',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.templates.create',
                'display_name' => 'Create Template',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.templates.edit',
                'display_name' => 'Edit Template',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.templates.delete',
                'display_name' => 'Delete Template',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.student.view',
                'display_name' => 'View Certificate',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.student.create',
                'display_name' => 'Create Certificate',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.student.edit',
                'display_name' => 'Edit Certificate',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'certificate.student.delete',
                'display_name' => 'Delete Certificate',
                'guard_name' => 'web',
                'orders' => 16,
                'created_at' => $now,
                'updated_at' => $now
            ],

            
            //Permission (order: 17)
            [
                'name' => 'role-permission',
                'display_name' => 'Role & Permission',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'role-permission.roles.index',
                'display_name' => 'Role',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'role-permission.roles.create',
                'display_name' => 'Create Role',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'role-permission.roles.edit',
                'display_name' => 'Edit Role',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'role-permission.roles.delete',
                'display_name' => 'Delete Role',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'role-permission.permissions.index',
                'display_name' => 'Permission',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'role-permission.permissions.assign-permission',
                'display_name' => 'Assign Permission',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'role-permission.users.view',
                'display_name' => 'User List',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'setting-management',
                'display_name' => 'Setting Management',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'setting-management.setting.index',
                'display_name' => 'Settings',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],
            [
                'name' => 'setting-management.setting.accounting',
                'display_name' => 'Accounting',
                'guard_name' => 'web',
                'orders' => 17,
                'created_at' => $now,
                'updated_at' => $now   
            ],

            // inventory (order: 18)
            [
                'name' => 'inventory',
                'display_name' => 'Inventory',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.product.view',
                'display_name' => 'View Products',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.product.create',
                'display_name' => 'Create Product',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.product.edit',
                'display_name' => 'Edit Product',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.product.delete',
                'display_name' => 'Delete Product',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.product.show',
                'display_name' => 'Show Product',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.sales.view',
                'display_name' => 'View Sales',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.sales.create',
                'display_name' => 'Create Sale',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.sales.edit',
                'display_name' => 'Edit Sale',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.sales.delete',
                'display_name' => 'Delete Sale',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'inventory.sales.show',
                'display_name' => 'Show Sale',
                'guard_name' => 'web',
                'orders' => 18,
                'created_at' => $now,
                'updated_at' => $now
            ],



            // Reports (order: 19)
            [
                'name' => 'report',
                'display_name' => 'Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.students.information',
                'display_name' => 'Student Information',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.students.class-section',
                'display_name' => 'Class Section Report',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.students.sibling',
                'display_name' => 'Sibling Report',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.view',
                'display_name' => 'Accounting Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.daily-collection',
                'display_name' => 'Daily Collection',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.payment-details',
                'display_name' => 'Payment Details',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.due-fees',
                'display_name' => 'Due Fees',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.income-report',
                'display_name' => 'Income Report',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.expense-report',
                'display_name' => 'Expense Report',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.income-expense-summary',
                'display_name' => 'Income Expense Summary',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.accounting.payroll-report',
                'display_name' => 'Payroll Report',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.exam-result.view',
                'display_name' => 'Exam & Result Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.attendance.view',
                'display_name' => 'Attendance Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.library.view',
                'display_name' => 'Library Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.syllabus.view',
                'display_name' => 'Syllabus Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.hostel.view',
                'display_name' => 'Hostel Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'report.transport.view',
                'display_name' => 'Transport Reports',
                'guard_name' => 'web',
                'orders' => 19,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // hsc order 20
            [
                'name' => 'hsc',
                'display_name' => 'HSC',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],

            [
                'name' => 'hsc.group-subject.view',
                'display_name' => 'Subject Grouping View',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.group-subject.store',
                'display_name' => 'Subject Grouping Store',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.group-subject.edit',
                'display_name' => 'Subject Grouping Edit',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],

            [
                'name' => 'hsc.group-subject.delete',
                'display_name' => 'Subject Grouping delete',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.hsc-admission.view',
                'display_name' => 'HSC Applicant',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.hsc-admission.store',
                'display_name' => 'HSC Applicant Store',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.hsc-admission.edit',
                'display_name' => 'HSC Applicant Edit',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.hsc-admission.show',
                'display_name' => 'HSC Applicant Show',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'hsc.hsc-admission.delete',
                'display_name' => 'HSC Applicant Delete',
                'guard_name' => 'web',
                'orders' => 20,
                'created_at' => $now,
                'updated_at' => $now
            ],

            // online-admission order 21
            [
                'name' => 'online-admission',
                'display_name' => 'Online Admission',
                'guard_name' => 'web',
                'orders' => 21,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'online-admission.applicant-list',
                'display_name' => 'Applicant List',
                'guard_name' => 'web',
                'orders' => 21,
                'created_at' => $now,
                'updated_at' => $now
            ],
            [
                'name' => 'online-admission.qualified-list',
                'display_name' => 'Qualified List',
                'guard_name' => 'web',
                'orders' => 21,
                'created_at' => $now,
                'updated_at' => $now
            ],


        ];

        //disable foreign key check
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        //Truncate permissions table
        DB::table('permissions')->truncate();

        // Insert permissions in chunks to handle large datasets efficiently
        foreach(array_chunk($permissions, 100) as $chunk) {
            DB::table('permissions')->insert($chunk);
        }

        //enable foreign key check
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
