<?php

namespace Database\Seeders;

use App\Models\HrPayroll\SalaryHead;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SalaryHeadSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('salary_heads')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
        $salaryHeads = [
            [
                'code' => 'GROSS',
                'title' => 'Gross',
                'type' => 'E',
            ],
            [
                'code' => 'BASIC',
                'title' => 'Basic',
                'type' => 'E',
            ],
            [
                'code' => 'HOUSE_RENT',
                'title' => 'House Rent',
                'type' => 'E',
            ],
            [
                'code' => 'MEDICAL',
                'title' => 'Medical',
                'type' => 'E',
            ],
            [
                'code' => 'TRANSPORT',
                'title' => 'Transport',
                'type' => 'E',
            ],
        ];


        SalaryHead::insert($salaryHeads);

    }
}
