<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ShiftSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //  Temporarily disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('shifts')->truncate();
        //  Enable foreign key checks again
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        DB::table('shifts')->insert([
            [
                'shift_name' => 'Morning',
                'start_time' => now(),
                'end_time' => now(),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'shift_name' => 'Day',
                'start_time' => now(),
                'end_time' => now(),
                'created_by' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
