<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class StudentClassesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {   
        //  Temporarily disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('student_classes')->truncate();
        //  Enable foreign key checks again
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        $ordinals = ['One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine', 'Ten'];
        for($i=0; $i<=9;$i++){
            DB::table('student_classes')->insert([
                'class_name' => $ordinals[$i],
                'created_at' => now()
            ]);
        }
    }
}
