<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use App\Models\Student\StudentInfo;

class StudentInfoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = \Faker\Factory::create();
        $users = User::where('user_type', 'student')->get();
        // Start ID from 1001
        $studentNumber = 1001;

        // Get current year last two digits
        $yearPrefix = date('y'); // e.g., '25' for 2025


        foreach($users as $user){
            $studentId = $yearPrefix . $studentNumber++; // e.g., 251000, 251001
            $user_id = $user->id;

            StudentInfo::create([
                'student_id_no' => $studentId,
                'user_id' => $user_id,
                'branch_id' => 1,
                'academic_year_id' => getDefaultAcademicYearID(),
                'first_name' => $user->first_name,
                'last_name' => $user->last_name,
                'name' => $user->first_name .' '. $user->last_name,
                'age' => $faker->numberBetween(12, 25),
                'gender' => $faker->randomElement(['Male', 'Female', 'Other']),
                'blood_group' => $faker->randomElement(['A+', 'B+', 'AB+', 'O+', 'A-', 'B-', 'AB-', 'O-']),
                'religion' => $faker->randomElement(['Islam']),
                'date_of_birth' => $faker->dateTimeBetween('-40 years', '-12 years')->format('Y-m-d'),
                'present_address' => $faker->address,
                'permanent_address' => $faker->address,
                'mobile_no' => $faker->phoneNumber,
                'email' => $user->email,
                'birth_certi_no' => $faker->randomNumber(6, true),
                'profile_image' => $faker->imageUrl,
                'shift_id' => $faker->numberBetween(1, 1),
                'student_class_id' => $faker->numberBetween(1, 1),
                'section_id' => $faker->numberBetween(1, 1),
                'version_id' => $faker->numberBetween(1, 1),
                'group_id' => null,
                'session' => $faker->year,
                'admission_roll' => $faker->randomNumber(4, true),
                'class_roll' => $faker->randomNumber(4, true),
                'year_admitted' => $faker->year,
                'student_photo' => $faker->imageUrl,
                'dormitory_id' => $faker->numberBetween(1, 1),
                'dorm_room_no' => $faker->numberBetween(1, 100),
                'father_name' => $faker->firstName . ' ' . $faker->lastName,
                'father_occupation' => $faker->jobTitle,
                'father_mobile' => $faker->phoneNumber,
                'mother_name' => $faker->firstName . ' ' . $faker->lastName,
                'mother_occupation' => $faker->jobTitle,
                'mother_mobile' => $faker->phoneNumber,
                'guardian_name' => $faker->firstName . ' ' . $faker->lastName,
                'guardian_occupation' => $faker->jobTitle,
                'guardian_mobile' => $faker->phoneNumber,
                'guardian_relationship' => $faker->word,
                'guardian_address' => $faker->address,
                'created_by' => 1,
                'updated_by' => 1,
            ]);
        }
    }
}
