<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class StudentTypeUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        // Create 50 fake users
        $faker = \Faker\Factory::create();

        // Create 50 fake users
        for ($i = 1; $i <= 50; $i++) {
            $firstName = $faker->firstName();
            $lastName = $faker->lastName();
            $fullName = $firstName . ' ' . $lastName;

            User::create([
                'first_name' => $firstName,
                'last_name' => $lastName,
                'name' => $fullName,
                'slug' =>  Str::slug($fullName),
                'user_type' => 'student', 
                'branch_id' => 1,
                'profile_image_path' => $faker->imageUrl(200, 200, 'people'),
                'email' => $faker->unique()->safeEmail(),
                'email_verified_at' => now(),
                'password' => Hash::make('12345678'),
                'status' => '1',
                'remember_token' => Str::random(10),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        } 
    }
}
