<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SubjectsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Temporarily disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('subjects')->truncate();
        // Enable foreign key checks again
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        
        DB::table('subjects')->insert([
            [
                'subject_name' => 'Bangla',
                'short_name' => 'BN',
                'subject_code' => '101',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'English',
                'short_name' => 'EN',
                'subject_code' => '102',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Mathmatics',
                'short_name' => 'MATH',
                'subject_code' => '103',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Science',
                'short_name' => 'S',
                'subject_code' => '104',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Social Science',
                'short_name' => 'SC',
                'subject_code' => '105',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Islamic Study',
                'short_name' => 'IS',
                'subject_code' => '106',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Physics',
                'short_name' => 'PH',
                'subject_code' => '107',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Chemistry',
                'short_name' => 'CH',
                'subject_code' => '108',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Higher Mathmatics',
                'short_name' => 'HMATH',
                'subject_code' => '109',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ],
            [
                'subject_name' => 'Biology',
                'short_name' => 'BIO',
                'subject_code' => '110',
                'is_optional' => false,
                'created_by' => 1,
                'created_at' => now()
            ]
        ]);
    }
}
