<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Faker\Factory as FakerFactory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = FakerFactory::create();
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('users')->truncate();
        //  Enable foreign key checks again
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        
        User::create([
            'name' => 'Super Admin',
            'first_name' => 'Super',
            'last_name' => 'Admin',
            'slug' =>  'super-admin',
            'user_type' => 'super-admin',
            'branch_id' => '1',
            'profile_image_path' => '/default/profile.png',
            'email' => 'superadmin@edueasy.com',
            'email_verified_at' => now(),
            'password' => Hash::make('12345678'),
            'status' => '1',
            'remember_token' => Str::random(10),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        User::create([
            'first_name' => 'Admin',
            'last_name' => 'Only',
            'name' => 'Admin Only',
            'slug' =>  'admin-only',
            'user_type' => 'admin',
            'branch_id' => 1,
            'profile_image_path' => $faker->imageUrl(),
            'email' => 'admin@edueasy.com',
            'email_verified_at' => now(),
            'password' => Hash::make('12345678'),
            'status' => '1',
            'remember_token' => Str::random(10),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // User::create([
        //     'first_name' => 'Teacher',
        //     'last_name' => 'One',
        //     'name' => 'Teacher One',
        //     'user_type' => 'teacher',
        //     'branch_id' => 1,
        //     'profile_image_path' => $faker->imageUrl(),
        //     'email' => 'teacherone@edueasy.com',
        //     'email_verified_at' => now(),
        //     'password' => Hash::make('12345678'),
        //     'status' => '1',
        //     'remember_token' => Str::random(10),
        //     'created_at' => now(),
        //     'updated_at' => now(),
        // ]);

        // User::create([
        //     'first_name' => 'Teacher',
        //     'last_name' => 'Two',
        //     'name' => 'Teacher Two',
        //     'user_type' => 'teacher',
        //     'branch_id' => 1,
        //     'profile_image_path' => $faker->imageUrl(),
        //     'email' => 'teachertwo@edueasy.com',
        //     'email_verified_at' => now(),
        //     'password' => Hash::make('12345678'),
        //     'status' => '1',
        //     'remember_token' => Str::random(10),
        //     'created_at' => now(),
        //     'updated_at' => now(),
        // ]);

        // User::create([
        //     'first_name' => 'Student',
        //     'last_name' => 'One',
        //     'name' => 'Student One',
        //     'user_type' => 'student',
        //     'branch_id' => 1,
        //     'profile_image_path' => $faker->imageUrl(),
        //     'email' => 'studentone@edueasy.com',
        //     'email_verified_at' => now(),
        //     'password' => Hash::make('12345678'),
        //     'status' => '1',
        //     'remember_token' => Str::random(10),
        //     'created_at' => now(),
        //     'updated_at' => now(),
        // ]);

        // User::create([
        //     'first_name' => 'Student',
        //     'last_name' => 'Two',
        //     'name' => 'Student Two',
        //     'user_type' => 'student',
        //     'branch_id' => 1,
        //     'profile_image_path' => $faker->imageUrl(),
        //     'email' => 'studenttwo@edueasy.com',
        //     'email_verified_at' => now(),
        //     'password' => Hash::make('12345678'),
        //     'status' => '1',
        //     'remember_token' => Str::random(10),
        //     'created_at' => now(),
        //     'updated_at' => now(),
        // ]);
    }
}
