function initializeColumnToggle(table, columnMappings) {
    $('input.toggle-column').on('change', function() {
        var columnId = $(this).val();
        var columnIndex = columnMappings[columnId];

        if (columnIndex !== undefined) {
            table.column(columnIndex).visible($(this).is(':checked'));
        }
    });

    $('.restorebutton').on('click', function() {
        $('input.toggle-column').prop('checked', true).trigger('change');
    });
}

function printTable(pageView='A4') {

    let htmlToPrint = '';
    let divToPrint = document.getElementsByClassName("table_content")[0];
    const newWin = window.open("");

    htmlToPrint = `
        <style type="text/css" media="print">
            @page { size: ${pageView}; }
            table {
                border-collapse: collapse;
                width: 100%;
                font-size: 14px;
            }
            table, th, td {
                border: 1px solid black;
            }
            th, td {
                padding: 8px;
                text-align: left;
            }
            thead > tr.table-secondary > th {
                background-color: #b3b7bb !important;
                color: black;
            }
            .hide-btn {
                visibility: hidden;
            }
        </style>
    `;

    newWin.document.write(htmlToPrint);
    newWin.document.write(`<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" type="text/css">`);
    newWin.document.write(divToPrint.outerHTML);
    newWin.document.close();

    setTimeout(function() {
        newWin.print();
        newWin.close();
    }, 100);
    
    
}

function handleExport(type, options = {}) {
    const defaultOptions = {
        url: '',
        filename: 'default',
        extraData: {}
    };

    const settings = { ...defaultOptions, ...options };

    // Get selected columns
    let selectedColumns = {};
    $('.toggle-column:checked').each(function() {
        const columnId = $(this).val();
        const columnName = $(this).data('column-name');
        selectedColumns[columnId] = columnName;
    });

    // Merge extra data with selected columns
    const data = {
        _token: document.querySelector('meta[name="csrf-token"]').content,
        selected_columns: selectedColumns,
        ...settings.extraData
    };
    const today = new Date().toISOString().substring(0, 10);

    const buttonId = type === 'xlsx' ? '#excel-btn' : type === 'pdf' ? '#pdf-btn' : '#print-btn';
    const originalIcon = $(`${buttonId} i`).attr('class');
    $(`${buttonId} i`).attr('class', 'fas fa-spinner fa-spin');
    $(buttonId).prop('disabled', true);

    // Make AJAX request
    $.ajax({
        url: settings.url,
        method: 'POST',
        data: data,
        xhrFields: {
            responseType: 'blob'
        },
        success: function(response) {
            const url = window.URL.createObjectURL(new Blob([response]));
            const a = document.createElement('a');
            a.href = url;
            a.download = `${settings.filename}_${today}.${type}`;
            document.body.appendChild(a);
            a.click();
            a.remove();
        },
        error: function(xhr) {
            console.error(`Error exporting ${type}:`, xhr.responseText);
        },
        complete: function() {
            $(`${buttonId} i`).attr('class', originalIcon);
            $(buttonId).prop('disabled', false);
        }
    });
}

// Export handlers
$(document).on('click', '#excel-btn', function(e) {

    e.preventDefault();
    if (typeof exportExcelOptions !== 'undefined') {
        handleExport('xlsx', {
            ...exportExcelOptions,
            filename: exportExcelOptions.filename || 'report'
        });
    }
});

$(document).on('click', '#pdf-btn', function(e) {
    e.preventDefault();
    if (typeof exportPdfOptions !== 'undefined') {
        handleExport('pdf', {
            ...exportPdfOptions,
            filename: exportPdfOptions.filename || 'report'
        });
    }
});

$(document).on('click', '#print-btn', function(e) {
    e.preventDefault();
    if (typeof exportPrintOptions !== 'undefined') {
        handlePrint(exportPrintOptions);
    }
});

function handlePrint(options) {
    let selectedColumns = {};
    $('.toggle-column:checked').each(function() {
        const columnId = $(this).val();
        const columnName = $(this).data('column-name');
        selectedColumns[columnId] = columnName;
    });

    // Clean up extraData by converting null values to empty strings
    const cleanExtraData = {};
    for (const [key, value] of Object.entries(options.extraData)) {
        cleanExtraData[key] = value === null ? '' : value;
    }

    const printWindow = window.open(options.url + '?' + new URLSearchParams({
        selected_columns: JSON.stringify(selectedColumns),
        ...cleanExtraData
    }), '_blank');

    printWindow.onload = function() {
        printWindow.print();
        printWindow.onafterprint = function() {
            printWindow.close();
        };
    };
} 