
<!DOCTYPE html>
<html lang="en">

@include('partials.header')
<body class="bg-gradient-login">
    <!-- Login Content -->
    <div class="container-login">
        <div class="row justify-content-center">
            <div class="col-xl-4 col-lg-6 col-md-9">
                <div class="card shadow-sm my-5">
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="login-form">
                                    <div class="text-center">
                                        <h1 class="h4 text-gray-900 mb-4">Forget Password</h1>
                                    </div>
                                    <form method="POST" action="{{ route('password.email') }}">
                                        @csrf
                                        <div class="form-group">
                                            <input type="text" name="email" class="form-control" id="exampleInputEmail"
                                                aria-describedby="emailHelp" value="" placeholder="Enter Email Address">
                                        </div>
                                        @if ($errors->any())
                                            @foreach ($errors->all() as $error)
                                                <li style="color:red;">{{$error}}</li>
                                            @endforeach
                                        @endif
                                        @if (session('status'))
                                            <div class="alert alert-success" role="alert">
                                                {{ session('status') }}
                                            </div>
                                        @endif
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary btn-block">Send Password Reset Link</a>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{url('/')}}" class="font-weight-bold small" href="register.html">Back to Login</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Login Content -->

    <script src="{{asset('assets/vendor/jquery/jquery.min.js')}}"></script>
    <script src="{{asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/vendor/jquery-easing/jquery.easing.min.js')}}"></script>
    <script src="{{asset('assets/js/ruang-admin.min.js')}}"></script>
</body>

</html>
