@extends('layouts.master')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-10">
                <div class="card shadow-sm my-5">
                    <div class="p-0">
                        <div class="login-form">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    @foreach ($errors->all() as $error)
                                        {{ $error }}
                                    @endforeach
                                </div>
                            @endif
                            @if (session('status'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('status') }}
                                </div>
                            @endif
                            <h5 class="mb-5 text-gray-900">Change your password</h5>
                            <form method="POST" action="{{ route('password.update') }}">
                                @csrf
                                <input type="hidden" name="token" value="{{ request()->route('token') }}">
                                <div class="form-group">
                                    <label for="current_password">Current password:</label>
                                    <input class="form-control" type="password" id="current_password" name="current_password"
                                           required>
                                </div>
                                <div class="form-group">
                                    <label for="password">New password:</label>
                                    <input class="form-control" type="password" id="password" name="password" required>
                                </div>
                                <div class="form-group">
                                    <label for="password_confirmation">Confirm new password:</label>
                                    <input class="form-control" type="password" id="password_confirmation"
                                           name="password_confirmation" required>
                                </div>
                                <br>
                                <a href="/" type="button" class="btn btn-default mr-3" data-dismiss="modal">Discard</a>
                                <button type="submit" class="btn btn-submit">Update Password</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

