<!DOCTYPE html>
<html lang="en">
<style>
</style>
@include('partials.header')
<body class="bg-gradient-login login__page">
<div class="container-login position-relative">
    <div class="row justify-content-center align-item-center">
        <div class="card">
            <div class="card-body p-0">
                <div class="login-form">
                    <div class="text-center">
                        @php
                            $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : 'uploads/images/logo.png';
                        @endphp
                        <a href="/" target="_blank" class="login__pg__logo"><img src="{{asset($logo_path)}}"
                                                                                 class="img-fluid"></a>
                        <h4 class="title mb-4">Reset Password</h4>
                    </div>
                    <form action="{{ route('forgot-password.reset.post') }}" method="POST">
                        @csrf
                        <input type="hidden" name="phone" value="{{ session('phone_number') }}">
                        <div class="form-group">
                            <input type="password" name="password" id="password" class="form-control" required
                                   placeholder="New Password">
                        </div>
                        <div class="form-group">
                            <input type="password" name="password_confirmation" id="password_confirmation"
                                   class="form-control" required placeholder="Confirm Password">
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary btn-block">Submit</button>
                        </div>
                    </form>
                    <hr>
                    <div class="text-center">
                        {{--                        <a class="small" href="{{ route('login') }}">Back to Login</a>--}}
                        <a class="small" href="{{route('forgot-password')}}"><span><svg
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="20"
                                    height="20" stroke-width="1">
  <path d="M9 14l-4 -4l4 -4"></path>
  <path d="M5 10h11a4 4 0 1 1 0 8h-1"></path>
</svg></span> Back to Forgot Password</a>
                    </div>
                </div>
                <div class="login_rightside_box">
                    <div id="overlapBanner" class="overlapBanner" style="width: 300px; display: block;">
                        <!--   BANNER TYPE 1     -->
                        <style type="text/css">
                            .img {
                                display: block;
                                width: 100%;
                                height: 240px;
                                margin: auto;
                                background-size: 100%;
                            }

                            .heading {
                                display: block;
                                text-align: center;
                                color: #000000c7;
                                font-weight: 700;
                                margin: 15px 0 3px;
                            }
                        </style>
                        <div class="img"
                             style="background-image: url('/assets/img/login.svg');"></div>
                        <div class="heading">Use Strong Password</div>
                        <div style="" class="banner1_content px-3 text-center">A password that uses special characters,
                            uppercase and
                            lowercase letters, and is long at 6 to 14 characters.
                        </div>
                    </div>
                </div>
            </div>
            <div class="credit text-center my-3">
                © 2021-<?php echo date("Y"); ?> <span>EduEasy</span>. All Rights Reserved.
            </div>
        </div>
    </div>
</div>
</body>
</html>
