<!DOCTYPE html>
<html lang="en">
<style>

</style>
@include('partials.header')
<body class="bg-gradient-login login__page">
<div class="container-login d-flex justify-content-center align-items-center min-vh-100 position-relative">
    <div class="">
        <div class="card">
            <div class="card-body p-0">
                <div class="login-form">
                    <div class="text-center">
                        @php
                            $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : 'uploads/images/logo.png';
                        @endphp
                        <a href="/" target="_blank" class="login__pg__logo"><img src="{{asset($logo_path)}}"
                                                                                 class="img-fluid"></a>
                        <h4 class="title mb-4">Verify OTP</h4>
                        <div class="otp__info d-block d-md-none d-lg-none">
                            <p>See your mobile and enter <b>Password Reset OTP</b> here.</p>
                        </div>
                    </div>
                    <form action="{{ route('forgot-password.verify.post') }}" method="POST">
                        @csrf
                        <input type="hidden" name="phone_number" value="{{ $phone_number }}">
                        <div class="form-group">
                            <input type="text" name="otp" id="otp" class="form-control" required
                                   placeholder="Enter Code">
                        </div>
                        @error('phone_error')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                        @error('otp')
                        <div class="otp__warning text-danger mb-2">( {{ $message }} )</div>
                        @enderror

                        <div class="">
                            <button type="submit"
                                    class="form-group login d-flex align-items-center justify-content-between">
                                <span>Next</span>
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="25"
                                    height="25"
                                    viewBox="0 0 24 24"
                                    fill="none"
                                    stroke="#fff"
                                    stroke-width="2"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                >
                                    <path d="M5 12l14 0"/>
                                    <path d="M13 18l6 -6"/>
                                    <path d="M13 6l6 6"/>
                                </svg>
                            </button>
                        </div>


{{--                        <div class="form-group">--}}
{{--                            <button type="submit" class="btn btn-primary btn-block">Submit</button>--}}
{{--                        </div>--}}
                    </form>
                    <div class="text-center">
                        {{--                        <a class="small" href="{{ route('login') }}">Back to Login</a>--}}
                        <a class="small" href="{{route('forgot-password')}}"><span><svg
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="20"
                                    height="20" stroke-width="1">
  <path d="M9 14l-4 -4l4 -4"></path>
  <path d="M5 10h11a4 4 0 1 1 0 8h-1"></path>
</svg></span> Back to Forgot Password</a>
                    </div>
                </div>
                <div class="login_rightside_box">
                    <div id="overlapBanner" class="overlapBanner" style="width: 300px; display: block;">
                        <!--   BANNER TYPE 1     -->
                        <style type="text/css">
                            .img {
                                display: block;
                                width: 100%;
                                height: 240px;
                                margin: auto;
                                background-size: 100%;
                            }

                            .heading {
                                display: block;
                                text-align: center;
                                color: #000000c7;
                                font-weight: 700;
                                margin: 15px 0 3px;
                            }
                        </style>
                        <div class="img"
                             style="background-image: url('/assets/img/login.svg');"></div>
                        <div class="heading">One Time Password (OTP)</div>
                        <div class="banner1_content px-3 text-center">Enter your login mobile no and submit <b>Send
                                OTP</b> button to receive a <b>Password Reset OTP</b></div>
                    </div>
                </div>
            </div>
            <div class="credit text-center my-3">
                © <?php echo date("Y"); ?> <span></span>. <span>Powered by <a href="https://www.edueasybd.com/"
                                                                              target="_blank"><img
                            src="https://www.edueasybd.com/logo.svg" style="max-height: 17px;"> </a></span>
            </div>
        </div>
    </div>
</div>
</body>
</html>
