<div class="chart__dash">
    <form id="present-absent-late-filter-form">
        <div class="row">
            <div class="col-md-2  col-6">
                <input type="text" id="present-absent-late-daterange" class="form-control form-control-sm" >
            </div>
            <div class="col-md-2  col-6">
                <button class="btn-sm btn-light-blue" type="submit">Filter</button>
            </div>
        </div>
    </form>
    <div class="chart__body" id="present-absent-late-compare"></div>
</div>

@push('scripts')
    <script>
        $(function () {
            let start = moment().subtract(30, 'days');
            let end = moment();
            // present-absent-late Initialize daterangepicker
            $('#present-absent-late-daterange').daterangepicker({
                startDate: start,
                endDate: end,
                locale: {
                    format: 'YYYY-MM-DD'  // ✅ Laravel-compatible format
                },
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, function(start, end) {
                // Set visible value in input field
                $('#present-absent-late-daterange').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
            });

            // Set default value manually on page load
            $('#present-absent-late-daterange').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));

            // Load chart on first page load
            loadChart(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));

            // Form submit handler
            $('#present-absent-late-filter-form').on('submit', function (e) {
                e.preventDefault();
                const range = $('#present-absent-late-daterange').val();

                if (!range.includes(' - ')) {
                    alert("Invalid date range format.");
                    return;
                }

                const [start, end] = range.split(' - ');
                console.log('Loading chart for:', start, end);

                loadChart(start.trim(), end.trim());
            });

            // Load chart with AJAX
            function loadChart(start, end) {
                $.ajax({
                    url: '{{ route("present-absent-late-compare") }}',
                    data: {
                        start_date: start,
                        end_date: end
                    },
                    success: function (res) {
                        Highcharts.chart('present-absent-late-compare', {
                            chart: {
                                type: 'line'
                            },
                            credits: {
                                enabled: false
                            },
                            title: {
                                text: 'Attendance Comparison'
                            },
                            xAxis: {
                                categories: res.categories,
                                crosshair: true
                            },
                            yAxis: {
                                min: 0,
                                title: {
                                    text: 'Total Students'
                                }
                            },
                            tooltip: {
                                shared: true,
                                crosshairs: true
                            },
                            plotOptions: {
                                line: {
                                    marker: {
                                        enabled: true
                                    }
                                }
                            },
                            series: [
                                {
                                    name: 'Present',
                                    data: res.series[0].data,
                                    color: '#00e272'
                                },
                                {
                                    name: 'Absent',
                                    data: res.series[1].data,
                                    color: '#2caffe'
                                }
                            ]
                        });
                    },
                    error: function (xhr) {
                        alert("Error loading chart: " + (xhr.responseJSON?.error || xhr.statusText));
                    }
                });
            }
        });
    </script>
@endpush
