<div class="row p-5 d-none d-print-block">
    <div class="col-md-12 d-flex align-items-center header">
        @php
            $logo_path = get_setting_value(Settings::EXPORT_LOGO)
                ? get_setting_value(Settings::EXPORT_LOGO)
                : 'uploads/images/logo.png';
            $institute_name = get_setting_value(Settings::SCHOOL_NAME)
                ? get_setting_value(Settings::SCHOOL_NAME)
                : '';
        @endphp
        <div class="logo">
            <img src="{{ asset($logo_path) }}" alt="Logo" class="img-fluid">
        </div>
        <div class="institute-info text-right">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2>
            <div class="download-date">
                Requisition Date: {{ date('d-m-Y') }}
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function () {

        $('#print-btn').on('click', function () {
            //print the print-layout div
            window.print();
        });
    });
</script>
@endpush

@section('styles')
<style>
    .header {
        padding: 20px 0;
    }

    .logo img {
        max-width: 180px; /* Adjust logo size */
        height: auto;
    }
    .institute-info {
        flex-grow: 1;
        text-align: right;
    }
    .institute-name {
        margin: 0;
        font-size: 1.5rem; /* Adjust font size */
    }
    .download-date {
        font-size: 0.9rem; /* Adjust font size */
        color: #6c757d; /* Bootstrap secondary color */
    }
</style>
@endsection